/*
 * RS485.h
 *
 *  Created on: 2013-07-16
 *      Author: mitydsp
 */

#ifndef RS485_H_
#define RS485_H_

#include <linux/serial.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include <string.h>

/* Driver-specific ioctls: */
#define TIOCGRS485 0x542E
#define TIOCSRS485 0x542F

/* new defines in linux/serial.h of CL provided kernel */
#ifndef SER_RS485_USE_GPIO
#define SER_RS485_USE_GPIO (1<<5)
#define gpio_pin padding[0]
#endif

#define GPIO0_9 (9)

#define USE2




// Common code belongs in the MityDSP namespace
namespace MityDSP
{
class tcArmRS485
{
private:
	struct serial_rs485 rs485conf;
	int i, rv, opt;
	struct termios my_termios, new_termios, stdio;
	bool isOpen;
public:
	int termHandle;
	bool isReady;
	tcArmRS485(void);
	virtual ~tcArmRS485();

};
} // end of MityDSP namespace

#endif /* RS485_H_ */
