----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    14:44:44 03/27/2014 
-- Design Name: 
-- Module Name:    clock - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
library UNISIM;
use UNISIM.VComponents.all;

entity core is
port
 (-- Clock in ports
  CLK_IN1           : in     std_logic;
  -- Clock out ports
  CLK_OUT1          : out    std_logic; -- Multiplied clock
  CLK_OUT2			  : out    std_logic;  -- Buffered Clock
  ADC_CLK_OUT		  : out 	  std_logic;
   -- Status and control signals
  RESET             : in     std_logic;
  INPUT_CLK_STOPPED : out    std_logic;
  LOCKED            : out    std_logic
 );
end core;

architecture clock_gen of core is
  attribute CORE_GENERATION_INFO : string;
  attribute CORE_GENERATION_INFO of clock_gen : architecture is "core,clk_wiz_v3_6,{component_name=core,use_phase_alignment=false,use_min_o_jitter=false,use_max_i_jitter=false,use_dyn_phase_shift=false,use_inclk_switchover=false,use_dyn_reconfig=false,feedback_source=FDBK_AUTO,primtype_sel=DCM_SP,num_out_clk=1,clkin1_period=151.515151515,clkin2_period=151.515151515,use_power_down=false,use_reset=true,use_locked=true,use_inclk_stopped=true,use_status=false,use_freeze=false,use_clk_valid=false,feedback_type=SINGLE,clock_mgr_type=AUTO,manual_override=false}";
  -- Input clock buffering / unused connectors
  signal clkin1            : std_logic;
  -- Output clock buffering
  signal clk_out1_internal : std_logic;
  signal clk_out2_internal : std_logic;
  signal clkfb             : std_logic;
  signal clkfx             : std_logic;
  signal clk0              : std_logic;
  signal clk1					: std_logic;
  signal clkfbout          : std_logic;
  signal locked_internal   : std_logic;
  signal status_internal   : std_logic_vector(7 downto 0);
  
begin


  -- Input buffering
  --------------------------------------
  clkin1_buf : IBUFG
  port map
   (O => clkin1,
    I => CLK_IN1);	
  
   ADC_CLK_OUT<= clkin1;


--  -- Clocking primitive
--  --------------------------------------
--  
--  -- Instantiation of the DCM primitive
--  --    * Unused inputs are tied off
--  --    * Unused outputs are labeled unused
  dcm_sp_inst: DCM_SP
  generic map
   (CLKDV_DIVIDE          => 2.000,
    CLKFX_DIVIDE          => 1,
    CLKFX_MULTIPLY        => 2,
    CLKIN_DIVIDE_BY_2     => FALSE,
    CLKIN_PERIOD          => 151.515151515,
    CLKOUT_PHASE_SHIFT    => "NONE",
    CLK_FEEDBACK          => "1X",
    DESKEW_ADJUST         => "SYSTEM_SYNCHRONOUS",
    PHASE_SHIFT           => 0,
    STARTUP_WAIT          => FALSE)
  port map
   -- Input clock
   (CLKIN                 => clkin1,
    CLKFB                 => clkfb,
    -- Output clocks
    CLK0                  => clk0,
    CLK90                 => open,
    CLK180                => open,
    CLK270                => open,
    CLK2X                 => open,
    CLK2X180              => open,
    CLKFX                 => clkfx,
    CLKFX180              => open,
    CLKDV                 => open,
   -- Ports for dynamic phase shift
    PSCLK                 => '0',
    PSEN                  => '0',
    PSINCDEC              => '0',
    PSDONE                => open,
   -- Other control and status signals
    LOCKED                => locked_internal,
    STATUS                => status_internal,
    RST                   => RESET,
   -- Unused pin, tie low
    DSSEN                 => '0');

	 INPUT_CLK_STOPPED     <= status_internal(1);
	 LOCKED                <= locked_internal;

  -- Output buffering
  -------------------------------------
  clkfb <= clk_out1_internal;
   

  clkout1_buf : BUFG
  port map
   (O   => clk_out1_internal, -- buffered
    I   => clk0);
	 
  clkout2_buf : BUFG
  port map
   (O   => clk_out2_internal,	-- multiplied
    I   => clkfx);

  CLK_OUT2 <= clk_out1_internal; -- buffered
  CLK_OUT1 <= clk_out2_internal; -- multiplied
  

end clock_gen;










 