#!/bin/bash
# must run this script with sudo, requires root privileges
if [ "$(id -u)" != "0" ]; then
	echo "Sorry, you are not root."
	exit 1
fi

# get all paths needed
source ./set_altera.sh

pushd ${DELIVERABLESDIR}

image_file=${DELIVERABLESDIR}/mitysom5csx_sensis.img

# create the reference SDCARD image
rm -rf ${image_file}

# 500 MB image is plenty for now
dd if=/dev/zero of=${image_file} bs=1 seek=500M count=0 >/dev/null 2>&1
RETVAL=$?

# exit on failure
if [ "$RETVAL" -ne "0" ]; then
  echo "????? dd failed @ Return value: $RETVAL ?????"
  popd > /dev/null
  exit $RETVAL
fi

# find the next available loop device and assign to loop (ex: /dev/loop0 /dev/loop1)
loop=`losetup -f`

# attach loop device to the image file
# ex: losetup /dev/loop0 image_file.img
losetup ${loop} ${image_file}
RETVAL=$?

# exit on failure
if [ "$RETVAL" -ne "0" ]; then
  echo "????? losetup ${loop} failed @ Return value: $RETVAL ?????"
  popd > /dev/null
  exit $RETVAL
fi

# create partition table
IMAGE_SIZE=$((1024 * 1024 * 1024))
# root filesystem (ext) 83 = linux
RFS_TYPE=83
RFS_NUM=1
RFS_SIZE=$((512 * 1024 * 1024))
RFS_OFFSET=$((4 * 1024 * 1024))

# create partions using fdisk on the loop device
cat <<EOT | fdisk ${loop}
c
u 
p
n
p
${RFS_NUM}
$((${RFS_OFFSET}/512))
+$((${RFS_SIZE}/1024))K
t
${RFS_TYPE}
p
w
EOT

RETVAL=$?

# exit on failure
#if [ "$RETVAL" -ne "0" ]; then
#  echo "????? fdisk ${loop} failed @ Return value: $RETVAL ?????"
#  popd > /dev/null
#  exit $RETVAL
#fi

sync
RETVAL=$?

# exit on failure
if [ "$RETVAL" -ne "0" ]; then
  echo "????? sync failed @ Return value: $RETVAL ?????"
  popd > /dev/null
  exit $RETVAL
fi

losetup -d ${loop}
RETVAL=$?

# exit on failure
if [ "$RETVAL" -ne "0" ]; then
  echo "????? losetup -d ${loop} failed @ Return value: $RETVAL ?????"
  popd > /dev/null
  exit $RETVAL
fi

# populate the filesystem
loop=`losetup -f`
losetup ${loop} -o ${RFS_OFFSET} --sizelimit ${RFS_SIZE} ${image_file}
mkfs -t ext3 ${loop}

# remove mount point directory to expand the root ball
rm -rf ./mnt

# make mount point for root ball
mkdir ./mnt


# mount the directory for the roo ball to the image file
mount -t ext3 ${loop} ./mnt



# move to the mnt directory/image file
pushd ./mnt > /dev/null

# untar the root ball into the image file
tar xvzf ${DELIVERABLESDIR}/core-image-sensis-mitysom-5csx.tar.gz


popd > /dev/null

find ./mnt | wc
umount ${loop}
losetup -d ${loop}

rm -rf ./mnt

popd > /dev/null

