#ifndef USB_H
#define USB_H

#include <pthread.h>

extern "C" {
struct usb_endpoint_descriptor;
struct usb_ctrlrequest;
};

namespace MityDSP {
class tcDspParserBase;
};

class tcReportError;

class tcUSB {
public:
	tcUSB(MityDSP::tcDspParserBase* apParser, int anSerial, tcReportError *apError);
	virtual ~tcUSB(void);

	int Initialize();

	int put(const char* data, int length, int flush = 1);

protected:
	int 		HandleControl(struct usb_ctrlrequest *setup);
	static void*	DispatchEP0Handler(void *apThis);
	static void*	DispatchBulkInHandler(void *apThis);
	int		EP0Handler(void);
	int		BulkInHandler(void);
	int		StartIO(void);
	int		StopIO(void);
	char*		build_config(char* cp, const struct usb_endpoint_descriptor **ep);
	
	int		mnEP0Fd; /* control endpoint file descriptor */
	int		mnBulkInFd; /* PC input bulk endpoint */
	int		mnBulkOutFd; /* PC output bulk endpoint */

	MityDSP::tcDspParserBase* mpParser;
	pthread_t	mhEP0Thread;
	pthread_t	mhBulkThread;
	pthread_t	mhStartupThread;

	int		mnBytesIn; /* counts the number of bytes received */
	tcReportError*	mpReportError; /* utility interface for error messages */
	bool		mbConnected;
};

#endif
