#!/bin/bash

root_ball=`pwd`/$1
image_file=mitysom5csx_devkit.img
home_files=`pwd`/home
boot_files=`pwd`/boot

if [ "$#" -ne 1 ] && [ "$#" -ne 2 ]; then
	echo "Usage: make_fs_image.sh root.tar.gz [filesystem patch folder]"
	exit 0
fi

patch_dir=""
if [ "$#" -eq 2 ]; then
	patch_dir=`pwd`/$2
fi

# create the reference SDCARD image
rm -rf ${image_file}

# 512 MB image is plenty for now
dd if=/dev/zero of=${image_file} bs=1 seek=1G count=0 >/dev/null 2>&1
loop=`losetup -f`
losetup ${loop} ./${image_file}

# create partition table
IMAGE_SIZE=$((1024 * 1024 * 1024))
# root filesystem (ext)
RFS_TYPE=83
RFS_NUM=2
RFS_SIZE=$((512 * 1024 * 1024))
RFS_OFFSET=$((312 * 1024 * 1024))

# spare filesystem (ext)
SPARE_TYPE=83
SPARE_NUM=1
SPARE_SIZE=$((256 * 1024 * 1024))
SPARE_OFFSET=$((4 * 1024 * 1024))

# raw partition for bootloader
RAW_TYPE=a2
RAW_NUM=3
RAW_SIZE=$((1024 * 1024))
RAW_OFFSET=$((1024 * 1024))
cat <<EOT | fdisk ${loop} 
p
n
p
${RFS_NUM}
$((${RFS_OFFSET}/512))
+$((${RFS_SIZE}/1024))K
t
${RFS_TYPE}
p
n
p
${SPARE_NUM}
$((${SPARE_OFFSET}/512))
+$((${SPARE_SIZE}/1024))K
t
${SPARE_NUM}
${SPARE_TYPE}
p
n
p
${RAW_NUM}
$((${RAW_OFFSET}/512))
+$((${RAW_SIZE}/1024))K
t
${RAW_NUM}
${RAW_TYPE}
p
w
EOT
sync
losetup -d ${loop}

# populate the filesystem
loop=`losetup -f`
losetup ${loop} -o ${RFS_OFFSET} --sizelimit ${RFS_SIZE} ./${image_file}
mkfs -t ext3 ${loop}
rm -rf ./mnt
mkdir ./mnt
mount -t ext3 ${loop} ./mnt
pushd ./mnt
tar xvzf ${root_ball}
if [ -n "$patch_dir" ]; then
	cp -rf $patch_dir/* ./
fi
popd
sync
sleep 5
find ./mnt | wc
umount ${loop}
losetup -d ${loop}
rm -rf ./mnt

# make a blank filesystem for spare
loop=`losetup -f`
losetup ${loop} -o ${SPARE_OFFSET} --sizelimit ${SPARE_SIZE} ./${image_file}
mkfs -t ext3 ${loop}
sync
losetup -d ${loop}

# stuff the preloader and u-boot
loop=`losetup -f`
losetup ${loop} -o ${RAW_OFFSET} --sizelimit ${RAW_SIZE} ./${image_file}
dd if=preloader-mkpimage.bin of=${loop} bs=64k seek=0
dd if=u-boot.img of=${loop} bs=64k seek=4
sync
losetup -d ${loop}

# stuff the u-boot environment
loop=`losetup -f`
losetup ${loop} ./${image_file}
dd if=ubootenv.bin of=${loop} bs=512 seek=1
sync
losetup -d ${loop}
