#!/bin/bash

# Launch a docker container which can be used to develop a yocto project
#
# Expected usage would be to cd into the yocto base directory and run
# this script
# jcormier 20190712

# Set default values
IMAGE_NAME=${IMAGE_NAME:-poky:ubuntu-18.04}
SERVER=${SERVER:-crops/}
IMAGE=${IMAGE:-"${SERVER}${IMAGE_NAME}"}
WORKDIR=${WORKDIR:-"$PWD"}

# Make bash history persistent atleast until host machine reboots
HISTORY=/tmp/.bash_history_$(id -u)
touch $HISTORY

docker run --rm -it -v "$WORKDIR:/work" -v $HISTORY:/home/pokyuser/.bash_history -v /home/tools:/home/tools --env "TOOLCHAIN_PATH_ARMV7=/home/tools/mitysom-57x/gcc-arm-8.3-2019.03-x86_64-arm-linux-gnueabihf" "$IMAGE" --workdir=/work

# Alternative way of launching image, skips entrypoint script and forces user id to match
#docker run --rm -it -u "$(id -u):$(id -g)" --entrypoint= -v $HISTORY:/home/pokyuser/.bash_history -v "$WORKDIR:/work" -w /work  "$IMAGE" bash

