--- Title: dcm_ctlr.vhd
---
---
---     o  0                          
---     | /       Copyright (c) 2011  
---    (CL)---o   Critical Link, LLC  
---      \                            
---       O                           
---
--- Company: Critical Link, LLC.
---
--- Revision History:
--- Version  Comments
--- 1.00     Initial Revision

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

library WORK;
use WORK.MityDSP_L138_pkg.ALL;

entity dcm_ctlr is
   Port ( 
      clk      : in std_logic;
      i_ABus   : in std_logic_vector(5 downto 0);
      i_DBus   : in std_logic_vector(15 downto 0);
      o_DBus   :out std_logic_vector(15 downto 0);
      i_wr_en  : in std_logic;
      i_rd_en  : in std_logic;
      i_cs     : in std_logic;
      o_irq    :out std_logic := '0';
      i_ilevel       : in std_logic_vector(1 downto 0) := "00";      
      i_ivector      : in std_logic_vector(3 downto 0) := "0000";   
      
      -- phase shift control logic
      o_psclk    : out std_logic; -- connect to DCM PSCLK
      o_psen     : out std_logic; -- connect to DCM PSEN
      o_psincdec : out std_logic; -- connect to DCM PSINCDEC
      i_psdone   : in  std_logic; -- connect to DCM PSDONE
      i_status_0 : in  std_logic; -- connect to DCM STATUS[0]  
      
      -- CLKGEN DFS Control (TODO)
      o_progen   : out std_logic; -- connect to DCM PROGEN
      o_progdata : out std_logic; -- connect to DCM PROGDATA
      i_progdone : out std_logic; -- connect to DCM PROGDONE
      i_locked   : in  std_logic  -- connect to DCM LOCKED
   );
end dcm_ctlr;

--*
--* @short Register Transfer Logic Implementation of DCM Controller core entity.
--* 
--/
architecture rtl of dcm_ctlr is

constant CORE_VERSION_MAJOR:  std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 01, 4);
constant CORE_VERSION_MINOR:  std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 01, 4);
constant CORE_ID:             std_logic_vector(7 downto 0) := CONV_STD_LOGIC_VECTOR( 24, 8);
constant CORE_YEAR:           std_logic_vector(4 downto 0) := CONV_STD_LOGIC_VECTOR( 11, 5);
constant CORE_MONTH:          std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 09, 4);
constant CORE_DAY:            std_logic_vector(4 downto 0) := CONV_STD_LOGIC_VECTOR( 20, 5);

signal version_reg       : std_logic_vector(15 downto 0);
signal ver_rd            : std_logic;

signal psen       : std_logic := '0';
signal psincdec   : std_logic := '1';
signal done_latch : std_logic := '0';

begin

version : core_version
   port map(
      clk           => clk,                  -- system clock
      rd            => ver_rd,               -- read enable
      ID            => CORE_ID,              -- assigned ID number, 0xFF if unassigned
      version_major => CORE_VERSION_MAJOR,   -- major version number 1-15
      version_minor => CORE_VERSION_MINOR,   -- minor version number 0-15
      year          => CORE_YEAR,            -- year since 2000
      month         => CORE_MONTH,           -- month (1-12)
      day           => CORE_DAY,             -- day (1-31)
      ilevel        => i_ilevel,
      ivector       => i_ivector,
      o_data        => version_reg
      );

reg_read : process (clk)
begin
   if rising_edge(clk) then
      
      ver_rd <= '0';

      -- address decoding
      if i_cs = '0' then
         o_DBus <= (others=>'0');
      else
         case i_ABus is
            when "000000" =>
               o_DBus <=  version_reg;
               ver_rd <= i_rd_en;
            when "000001" =>
               o_DBus <= x"000" & "00" & i_status_0 & done_latch;
            when others =>
               o_DBus <= (others=>'0');
         end case;
      end if;
   end if;
end process reg_read;

o_irq <= '0';

reg_write : process (clk)
begin
   if rising_edge(clk) then
      
      if i_cs='1' and i_wr_en='1' and i_ABus ="000001" then
          if i_DBus(0)='1' then
             done_latch <= '0';
          end if;
      elsif  i_psdone='1' then
          done_latch <= '1';
      end if;

      if i_cs = '1' and i_wr_en = '1' then
         case i_ABus is
            when "000001" =>
                if i_DBus(2)='1' then
                   psen <= '1';
                end if;
                psincdec <= i_DBus(3);
            when others => NULL;
         end case;
      else
         psen <= '0';
      end if;
   end if;
end process reg_write;

o_psclk    <= clk;
o_psen     <= psen;
o_psincdec <= psincdec;

end rtl;
