library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity DDC232_sim is
   port (
      clk      : in  std_logic; -- assuming 4x input clock mode
      conv     : in  std_logic;
      din_cfg  : in  std_logic;
      clk_cfg  : in  std_logic;
      reset_n  : in  std_logic;
      dvalid_n : out std_logic;
      dclk     : in  std_logic;
      dout     : out std_logic;
      din      : in  std_logic
   );
end DDC232_sim;

architecture sim of DDC232_sim is

constant tCMDR : integer := 1384 * 4; -- times four because of 4x input clock

subtype T_SIM_DATA is std_logic_vector(32*20-1 downto 0);
signal sim_data  : T_SIM_DATA;
signal shift_reg : T_SIM_DATA := (others=>'0');
signal dvalid : std_logic := '1'; -- test condition that dvalid is already active when capture starts
signal dvalid_tgl : std_logic := '0';

function data_incr (indata : T_SIM_DATA; init : boolean) return T_SIM_DATA is
variable result : T_SIM_DATA;
begin
   for i in 0 to 31 loop
      if init = true then
         result(20*i+19 downto 20*i) := conv_std_logic_vector(i, 20);
      else
         result(20*i+19 downto 20*i) := indata(20*i+19 downto 20*i) + '1';
      end if;
   end loop;
   
   return result;
end data_incr;

begin -- architecture: sim

dvalid_tgl_gen : process
variable drdy_cntr : integer := tCMDR;
begin
   sim_data <= data_incr(sim_data, true);
   
   loop
      wait until rising_edge(conv) or falling_edge(conv);
      
      sim_data <= data_incr(sim_data, false);
      drdy_cntr := 0;
      
      while drdy_cntr < tCMDR loop
         wait until rising_edge(clk);
         drdy_cntr := drdy_cntr + 1;
      end loop;
      
      dvalid_tgl <= not dvalid_tgl;
   end loop;
end process dvalid_tgl_gen;

dvalid <= '1' when rising_edge(dvalid_tgl) or falling_edge(dvalid_tgl) else
          '0' when falling_edge(dclk);

shift : process (dclk, dvalid)
begin
   if rising_edge(dvalid) then
      shift_reg <= sim_data;
   elsif falling_edge(dclk) then
--      shift_reg <= din & shift_reg(32*20-1 downto 1);
      shift_reg <= shift_reg(32*20-2 downto 0) & din;
   end if;
end process shift;

--dout <= shift_reg(0);
dout <= shift_reg(32*20-1);
dvalid_n <= not dvalid;

end sim;
