--- Title: tfp410.vhd
--- Description: 
---
---     o  0
---     | /       Copyright (c) 2010
---    (CL)---o   Critical Link, LLC
---      \
---       O
---
--- Company: Critical Link, LLC.
--- Date: 3/7/2010
--- Version: 1.00
--- Revisions: 
---   1.00 - Initial release.

library IEEE;
library UNISIM;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use UNISIM.VCOMPONENTS.ALL;

library WORK;
use WORK.MityDSP_L138_pkg.ALL;

entity tfp410 is
   port (
      ema_clk         : in std_logic;
      i_cs            : in std_logic;
      i_ABus          : in std_logic_vector(5 downto 0);
      i_DBus          : in std_logic_vector(15 downto 0);
      o_DBus          : out std_logic_vector(15 downto 0);
      i_wr_en         : in std_logic;
      i_rd_en         : in std_logic;
      o_irq           : out std_logic;
      i_ilevel       : in std_logic_vector(1 downto 0) := "00";       -- interrupt level (0=4,1=5,2=6,3=7)
      i_ivector      : in std_logic_vector(3 downto 0) := "0000";    -- interrupt vector (0 through 31)
      
      -- LCD Controller interface (from OMAP-L138)
      i_lcd_d       : in std_logic_vector(15 downto 0);
      i_lcd_hsync   : in std_logic;
      i_lcd_vsync   : in std_logic;
      i_lcd_mclk    : in std_logic;
      i_lcd_pclk    : in std_logic;
      i_lcd_enb     : in std_logic;
            
      -- DVI video interface (we assume double data rate interface for pin reduction)
      -- these should be hooked up to the ODDR2 macro...
      o_dvi_data_c0 : out std_logic_vector(11 downto 0);
      o_dvi_data_c1 : out std_logic_vector(11 downto 0);
      o_dvi_clk     : out std_logic;
      o_dvi_hsync   : out std_logic;
      o_dvi_vsync   : out std_logic;
      o_dvi_de      : out std_logic
            
      );
end tfp410;

architecture rtl of tfp410 is

constant CORE_ID:             std_logic_vector(7 downto 0) := CONV_STD_LOGIC_VECTOR( 1, 8);
constant CORE_VERSION_MAJOR:  std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 1, 4);
constant CORE_VERSION_MINOR:  std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR( 0, 4);
constant CORE_YEAR:           std_logic_vector(4 downto 0) := CONV_STD_LOGIC_VECTOR(10, 5);
constant CORE_MONTH:          std_logic_vector(3 downto 0) := CONV_STD_LOGIC_VECTOR(03, 4);
constant CORE_DAY:            std_logic_vector(4 downto 0) := CONV_STD_LOGIC_VECTOR(08, 5);

signal version_reg : std_logic_vector(15 downto 0) := (others=>'0');
signal version_rd  : std_logic;

signal write_addr : std_logic_vector(4 downto 0) := "00000";
signal read_addr  : std_logic_vector(4 downto 0) := "10000";
signal fifo_din, fifo_dout : std_logic_vector(26 downto 0);


begin

o_irq <= '0';

version : core_version
   port map(
      clk           => ema_clk,
      rd            => version_rd,
      ID            => CORE_ID,
      version_major => CORE_VERSION_MAJOR,
      version_minor => CORE_VERSION_MINOR,
      year          => CORE_YEAR,
      month         => CORE_MONTH,
      day           => CORE_DAY,
      ilevel        => i_ilevel,
      ivector       => i_ivector,
      o_data        => version_reg
      );

reg_read : process (ema_clk)
begin
   if rising_edge(ema_clk) then
      
      version_rd <= '0';
      
      if i_cs='0' then
         o_DBus <= (others=>'0');
      else
         case i_ABus is
            when "000000" =>
               o_DBus <= version_reg;
               version_rd <= i_rd_en;
            when others =>
               o_DBus <= (others=>'0');
         end case;
      end if;
   end if;
end process reg_read;

reg_write : process (ema_clk)
begin
   if rising_edge(ema_clk) then
      if i_cs='1' and i_wr_en='1' then
               
         case i_ABus is
            when "000010" => NULL;
            when others => NULL;
         end case;
         
      end if;
   end if;
end process reg_write;

FIFOBLOCK : for i in 0 to 26 generate
begin
RAM32x1FIFO : RAM32X1D
   generic map ( INIT => X"00000000" )
   port map (
       DPO => fifo_dout(i),
       SPO => open,
       A0  => write_addr(0),
       A1  => write_addr(1),
       A2  => write_addr(2),
       A3  => write_addr(3),
       A4  => write_addr(4),
       D   => fifo_din(i),
       DPRA0 => read_addr(0),
       DPRA1 => read_addr(1),
       DPRA2 => read_addr(2),
       DPRA3 => read_addr(3),
       DPRA4 => read_addr(4),
       WCLK  => i_lcd_pclk,
       WE    => '1' );    
end generate;

writeaddr : process(i_lcd_pclk)
begin
    if rising_edge(i_lcd_pclk) then
        write_addr <= write_addr+'1';
    end if;
end process writeaddr;

readaddr : process(i_lcd_pclk)
begin
    if rising_edge(i_lcd_pclk) then
       read_addr <= read_addr+'1';
    end if;
end process readaddr;

-- blue in
fifo_din(7 downto 0)  <= i_lcd_d(4 downto 0) & "000";
-- green in
fifo_din(15 downto 8)  <= i_lcd_d(10 downto 5) & "00";
-- red in
fifo_din(23 downto 16)  <= i_lcd_d(15 downto 11) & "000";
fifo_din(26 downto 24)  <= i_lcd_enb & i_lcd_vsync & i_lcd_hsync;

o_dvi_data_c1 <= fifo_dout(11 downto 0);   -- Green[3:0] & Blue [7:0]
o_dvi_data_c0 <= fifo_dout(23 downto 12);  -- Red[7:0] & green [7:3]

o_dvi_clk <= i_lcd_pclk;

o_dvi_hsync <= fifo_dout(24);
o_dvi_vsync <= fifo_dout(25);
o_dvi_de    <= fifo_dout(26);

end rtl;