/**
 * \file  hw_eqep.h
 *
 * \brief EQEP register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_EQEP_H_
#define _HW_EQEP_H_

#ifdef __cplusplus
extern "C" {
#endif

#define EQEP_QPOSCNT		(0x0)
#define EQEP_QPOSINIT		(0x4)
#define EQEP_QPOSMAX		(0x8)
#define EQEP_QPOSCMP		(0xC)
#define EQEP_QPOSILAT		(0x10)
#define EQEP_QPOSSLAT		(0x14)
#define EQEP_QPOSLAT		(0x18)
#define EQEP_QUTMR		(0x1C)
#define EQEP_QUPRD		(0x20)
#define EQEP_QWDTMR		(0x24)
#define EQEP_QWDPRD		(0x26)
#define EQEP_QDECCTL		(0x28)
#define EQEP_QEPCTL		(0x2A)
#define EQEP_QCAPCTL		(0x2C)
#define EQEP_QPOSCTL		(0x2E)
#define EQEP_QEINT		(0x30)
#define EQEP_QFLG		(0x32)
#define EQEP_QCLR		(0x34)
#define EQEP_QFRC		(0x36)
#define EQEP_QEPSTS		(0x38)
#define EQEP_QCTMR		(0x3A)
#define EQEP_QCPRD		(0x3C)
#define EQEP_QCTMRLAT		(0x3E)
#define EQEP_QCPRDLAT		(0x40)
#define EQEP_REVID		(0x5A)

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* QPOSCNT */

#define EQEP_QPOSCNT_QPOSCNT (0xFFFFFFFFu)
#define EQEP_QPOSCNT_QPOSCNT_SHIFT (0x00000000u)


/* QPOSINIT */

#define EQEP_QPOSINIT_QPOSINIT (0xFFFFFFFFu)
#define EQEP_QPOSINIT_QPOSINIT_SHIFT (0x00000000u)


/* QPOSMAX */

#define EQEP_QPOSMAX_QPOSMAX (0xFFFFFFFFu)
#define EQEP_QPOSMAX_QPOSMAX_SHIFT (0x00000000u)


/* QPOSCMP */

#define EQEP_QPOSCMP_QPOSCMP (0xFFFFFFFFu)
#define EQEP_QPOSCMP_QPOSCMP_SHIFT (0x00000000u)


/* QPOSILAT */

#define EQEP_QPOSILAT_QPOSILAT (0xFFFFFFFFu)
#define EQEP_QPOSILAT_QPOSILAT_SHIFT (0x00000000u)


/* QPOSSLAT */

#define EQEP_QPOSSLAT_QPOSSLAT (0xFFFFFFFFu)
#define EQEP_QPOSSLAT_QPOSSLAT_SHIFT (0x00000000u)


/* QPOSLAT */

#define EQEP_QPOSLAT_QPOSLAT (0xFFFFFFFFu)
#define EQEP_QPOSLAT_QPOSLAT_SHIFT (0x00000000u)


/* QUTMR */

#define EQEP_QUTMR_QUTMR (0xFFFFFFFFu)
#define EQEP_QUTMR_QUTMR_SHIFT (0x00000000u)


/* QUPRD */

#define EQEP_QUPRD_QUPRD (0xFFFFFFFFu)
#define EQEP_QUPRD_QUPRD_SHIFT (0x00000000u)


/* QWDTMR */

#define EQEP_QWDTMR_QWDTMR (0xFFFFu)
#define EQEP_QWDTMR_QWDTMR_SHIFT (0x0000u)


/* QWDPRD */

#define EQEP_QWDPRD_QWDPRD (0xFFFFu)
#define EQEP_QWDPRD_QWDPRD_SHIFT (0x0000u)


/* QDECCTL */

#define EQEP_QDECCTL_QSRC (0xC000u)
#define EQEP_QDECCTL_QSRC_SHIFT (0x000Eu)
#define EQEP_QDECCTL_QSRC_QUADCOUNT (0x0000u)
#define EQEP_QDECCTL_QSRC_DIRCOUNT (0x0001u)
#define EQEP_QDECCTL_QSRC_UPCOUNT (0x0002u)
#define EQEP_QDECCTL_QSRC_DOWNCOUNT (0x0003u)

#define EQEP_QDECCTL_SOEN (0x2000u)
#define EQEP_QDECCTL_SOEN_SHIFT (0x000Du)

#define EQEP_QDECCTL_SPSEL (0x1000u)
#define EQEP_QDECCTL_SPSEL_SHIFT (0x000Cu)

#define EQEP_QDECCTL_XCR (0x0800u)
#define EQEP_QDECCTL_XCR_SHIFT (0x000Bu)

#define EQEP_QDECCTL_SWAP (0x0400u)
#define EQEP_QDECCTL_SWAP_SHIFT (0x000Au)

#define EQEP_QDECCTL_IGATE (0x0200u)
#define EQEP_QDECCTL_IGATE_SHIFT (0x0009u)

#define EQEP_QDECCTL_QAP (0x0100u)
#define EQEP_QDECCTL_QAP_SHIFT (0x0008u)

#define EQEP_QDECCTL_QBP (0x0080u)
#define EQEP_QDECCTL_QBP_SHIFT (0x0007u)

#define EQEP_QDECCTL_QIP (0x0040u)
#define EQEP_QDECCTL_QIP_SHIFT (0x0006u)

#define EQEP_QDECCTL_QSP (0x0020u)
#define EQEP_QDECCTL_QSP_SHIFT (0x0005u)



/* QEPCTL */

#define EQEP_QEPCTL_FREESOFT (0xC000u)
#define EQEP_QEPCTL_FREESOFT_SHIFT (0x000Eu)
#define EQEP_QEPCTL_FREESOFT_STOPNOW (0x0000u)
#define EQEP_QEPCTL_FREESOFT_COUNTUNTIL (0x0001u)
#define EQEP_QEPCTL_FREESOFT_IGNORE (0x0002u)
#define EQEP_QEPCTL_FREESOFT_IGNORE1 (0x0003u)

#define EQEP_QEPCTL_PCRM (0x3000u)
#define EQEP_QEPCTL_PCRM_SHIFT (0x000Cu)
#define EQEP_QEPCTL_PCRM_ONINDEX (0x0000u)
#define EQEP_QEPCTL_PCRM_ONMAXPOS (0x0001u)
#define EQEP_QEPCTL_PCRM_ON1STINDEX (0x0002u)
#define EQEP_QEPCTL_PCRM_ONUTEVT (0x0003u)

#define EQEP_QEPCTL_SEI (0x0C00u)
#define EQEP_QEPCTL_SEI_SHIFT (0x000Au)
#define EQEP_QEPCTL_SEI_NOEFFECT (0x0000u)
#define EQEP_QEPCTL_SEI_NOEFFECT1 (0x0001u)
#define EQEP_QEPCTL_SEI_ONREDGE (0x0002u)
#define EQEP_QEPCTL_SEI_ONFEDGE (0x0003u)

#define EQEP_QEPCTL_IEI (0x0300u)
#define EQEP_QEPCTL_IEI_SHIFT (0x0008u)
#define EQEP_QEPCTL_IEI_NOEFFECT (0x0000u)
#define EQEP_QEPCTL_IEI_NOEFFECT1 (0x0001u)
#define EQEP_QEPCTL_IEI_ONREDGE (0x0002u)
#define EQEP_QEPCTL_IEI_ONFEDGE (0x0003u)

#define EQEP_QEPCTL_SWI (0x0080u)
#define EQEP_QEPCTL_SWI_SHIFT (0x0007u)

#define EQEP_QEPCTL_SEL (0x0040u)
#define EQEP_QEPCTL_SEL_SHIFT (0x0006u)

#define EQEP_QEPCTL_IEL (0x0030u)
#define EQEP_QEPCTL_IEL_SHIFT (0x0004u)
#define EQEP_QEPCTL_IEL_RESERVED (0x0000u)
#define EQEP_QEPCTL_IEL_ONREDGE (0x0001u)
#define EQEP_QEPCTL_IEL_ONFEDGE (0x0002u)
#define EQEP_QEPCTL_IEL_SWINDEX (0x0003u)

#define EQEP_QEPCTL_QPEN (0x0008u)
#define EQEP_QEPCTL_QPEN_SHIFT (0x0003u)

#define EQEP_QEPCTL_QCLM (0x0004u)
#define EQEP_QEPCTL_QCLM_SHIFT (0x0002u)

#define EQEP_QEPCTL_UTE (0x0002u)
#define EQEP_QEPCTL_UTE_SHIFT (0x0001u)

#define EQEP_QEPCTL_WDE (0x0001u)
#define EQEP_QEPCTL_WDE_SHIFT (0x0000u)


/* QCAPCTL */

#define EQEP_QCAPCTL_CEN (0x8000u)
#define EQEP_QCAPCTL_CEN_SHIFT (0x000Fu)

#define EQEP_QCAPCTL_CCPS (0x0070u)
#define EQEP_QCAPCTL_CCPS_SHIFT (0x0004u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV1 (0x0000u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV2 (0x0001u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV4 (0x0002u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV8 (0x0003u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV16 (0x0004u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV32 (0x0005u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV64 (0x0006u)
#define EQEP_QCAPCTL_CCPS_SYSCLKOUTDIV128 (0x0007u)

#define EQEP_QCAPCTL_UPPS (0x000Fu)
#define EQEP_QCAPCTL_UPPS_SHIFT (0x0000u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV1 (0x0000u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV2 (0x0001u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV4 (0x0002u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV8 (0x0003u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV16 (0x0004u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV32 (0x0005u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV64 (0x0006u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV128 (0x0007u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV256 (0x0008u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV512 (0x0009u)
#define EQEP_QCAPCTL_UPPS_QCLKDIV1024 (0x000Au)
#define EQEP_QCAPCTL_UPPS_QCLKDIV2048 (0x000Bu)


/* QPOSCTL */

#define EQEP_QPOSCTL_PCSHDW (0x8000u)
#define EQEP_QPOSCTL_PCSHDW_SHIFT (0x000Fu)
#define EQEP_QPOSCTL_PCLOAD (0x4000u)
#define EQEP_QPOSCTL_PCLOAD_SHIFT (0x000Eu)

#define EQEP_QPOSCTL_PCPOL (0x2000u)
#define EQEP_QPOSCTL_PCPOL_SHIFT (0x000Du)

#define EQEP_QPOSCTL_PCE (0x1000u)
#define EQEP_QPOSCTL_PCE_SHIFT (0x000Cu)

#define EQEP_QPOSCTL_PCSPW (0x0FFFu)
#define EQEP_QPOSCTL_PCSPW_SHIFT (0x0000u)


/* QEINT */


#define EQEP_QEINT_UTO (0x0800u)
#define EQEP_QEINT_UTO_SHIFT (0x000Bu)

#define EQEP_QEINT_IEL (0x0400u)
#define EQEP_QEINT_IEL_SHIFT (0x000Au)

#define EQEP_QEINT_SEL (0x0200u)
#define EQEP_QEINT_SEL_SHIFT (0x0009u)

#define EQEP_QEINT_PCM (0x0100u)
#define EQEP_QEINT_PCM_SHIFT (0x0008u)

#define EQEP_QEINT_PCR (0x0080u)
#define EQEP_QEINT_PCR_SHIFT (0x0007u)

#define EQEP_QEINT_PCO (0x0040u)
#define EQEP_QEINT_PCO_SHIFT (0x0006u)

#define EQEP_QEINT_PCU (0x0020u)
#define EQEP_QEINT_PCU_SHIFT (0x0005u)

#define EQEP_QEINT_WTO (0x0010u)
#define EQEP_QEINT_WTO_SHIFT (0x0004u)

#define EQEP_QEINT_QDC (0x0008u)
#define EQEP_QEINT_QDC_SHIFT (0x0003u)

#define EQEP_QEINT_PHE (0x0004u)
#define EQEP_QEINT_PHE_SHIFT (0x0002u)

#define EQEP_QEINT_PCE (0x0002u)
#define EQEP_QEINT_PCE_SHIFT (0x0001u)



/* QFLG */


#define EQEP_QFLG_UTO (0x0800u)
#define EQEP_QFLG_UTO_SHIFT (0x000Bu)
#define EQEP_QFLG_UTO_NOINT (0x0000u)
#define EQEP_QFLG_UTO_INT (0x0001u)

#define EQEP_QFLG_IEL (0x0400u)
#define EQEP_QFLG_IEL_SHIFT (0x000Au)

#define EQEP_QFLG_SEL (0x0200u)
#define EQEP_QFLG_SEL_SHIFT (0x0009u)

#define EQEP_QFLG_PCM (0x0100u)
#define EQEP_QFLG_PCM_SHIFT (0x0008u)

#define EQEP_QFLG_PCR (0x0080u)
#define EQEP_QFLG_PCR_SHIFT (0x0007u)

#define EQEP_QFLG_PCO (0x0040u)
#define EQEP_QFLG_PCO_SHIFT (0x0006u)

#define EQEP_QFLG_PCU (0x0020u)
#define EQEP_QFLG_PCU_SHIFT (0x0005u)

#define EQEP_QFLG_WTO (0x0010u)
#define EQEP_QFLG_WTO_SHIFT (0x0004u)

#define EQEP_QFLG_QDC (0x0008u)
#define EQEP_QFLG_QDC_SHIFT (0x0003u)

#define EQEP_QFLG_PHE (0x0004u)
#define EQEP_QFLG_PHE_SHIFT (0x0002u)

#define EQEP_QFLG_PCE (0x0002u)
#define EQEP_QFLG_PCE_SHIFT (0x0001u)

#define EQEP_QFLG_INT (0x0001u)
#define EQEP_QFLG_INT_SHIFT (0x0000u)


/* QCLR */


#define EQEP_QCLR_UTO (0x0800u)
#define EQEP_QCLR_UTO_SHIFT (0x000Bu)

#define EQEP_QCLR_IEL (0x0400u)
#define EQEP_QCLR_IEL_SHIFT (0x000Au)

#define EQEP_QCLR_SEL (0x0200u)
#define EQEP_QCLR_SEL_SHIFT (0x0009u)

#define EQEP_QCLR_PCM (0x0100u)
#define EQEP_QCLR_PCM_SHIFT (0x0008u)

#define EQEP_QCLR_PCR (0x0080u)
#define EQEP_QCLR_PCR_SHIFT (0x0007u)

#define EQEP_QCLR_PCO (0x0040u)
#define EQEP_QCLR_PCO_SHIFT (0x0006u)

#define EQEP_QCLR_PCU (0x0020u)
#define EQEP_QCLR_PCU_SHIFT (0x0005u)

#define EQEP_QCLR_WTO (0x0010u)
#define EQEP_QCLR_WTO_SHIFT (0x0004u)

#define EQEP_QCLR_QDC (0x0008u)
#define EQEP_QCLR_QDC_SHIFT (0x0003u)

#define EQEP_QCLR_PHE (0x0004u)
#define EQEP_QCLR_PHE_SHIFT (0x0002u)

#define EQEP_QCLR_PCE (0x0002u)
#define EQEP_QCLR_PCE_SHIFT (0x0001u)

#define EQEP_QCLR_INT (0x0001u)
#define EQEP_QCLR_INT_SHIFT (0x0000u)


/* QFRC */


#define EQEP_QFRC_UTO (0x0800u)
#define EQEP_QFRC_UTO_SHIFT (0x000Bu)

#define EQEP_QFRC_IEL (0x0400u)
#define EQEP_QFRC_IEL_SHIFT (0x000Au)

#define EQEP_QFRC_SEL (0x0200u)
#define EQEP_QFRC_SEL_SHIFT (0x0009u)

#define EQEP_QFRC_PCM (0x0100u)
#define EQEP_QFRC_PCM_SHIFT (0x0008u)

#define EQEP_QFRC_PCR (0x0080u)
#define EQEP_QFRC_PCR_SHIFT (0x0007u)

#define EQEP_QFRC_PCO (0x0040u)
#define EQEP_QFRC_PCO_SHIFT (0x0006u)

#define EQEP_QFRC_PCU (0x0020u)
#define EQEP_QFRC_PCU_SHIFT (0x0005u)

#define EQEP_QFRC_WTO (0x0010u)
#define EQEP_QFRC_WTO_SHIFT (0x0004u)

#define EQEP_QFRC_QDC (0x0008u)
#define EQEP_QFRC_QDC_SHIFT (0x0003u)

#define EQEP_QFRC_PHE (0x0004u)
#define EQEP_QFRC_PHE_SHIFT (0x0002u)

#define EQEP_QFRC_PCE (0x0002u)
#define EQEP_QFRC_PCE_SHIFT (0x0001u)



/* QEPSTS */


#define EQEP_QEPSTS_UPEVNT (0x0080u)
#define EQEP_QEPSTS_UPEVNT_SHIFT (0x0007u)

#define EQEP_QEPSTS_FDF (0x0040u)
#define EQEP_QEPSTS_FDF_SHIFT (0x0006u)

#define EQEP_QEPSTS_QDF (0x0020u)
#define EQEP_QEPSTS_QDF_SHIFT (0x0005u)

#define EQEP_QEPSTS_QDLF (0x0010u)
#define EQEP_QEPSTS_QDLF_SHIFT (0x0004u)

#define EQEP_QEPSTS_COEF (0x0008u)
#define EQEP_QEPSTS_COEF_SHIFT (0x0003u)

#define EQEP_QEPSTS_CDEF (0x0004u)
#define EQEP_QEPSTS_CDEF_SHIFT (0x0002u)

#define EQEP_QEPSTS_FIMF (0x0002u)
#define EQEP_QEPSTS_FIMF_SHIFT (0x0001u)

#define EQEP_QEPSTS_PCEF (0x0001u)
#define EQEP_QEPSTS_PCEF_SHIFT (0x0000u)


/* QCTMR */

#define EQEP_QCTMR_QCTMR (0xFFFFu)
#define EQEP_QCTMR_QCTMR_SHIFT (0x0000u)


/* QCPRD */

#define EQEP_QCPRD_QCPRD (0xFFFFu)
#define EQEP_QCPRD_QCPRD_SHIFT (0x0000u)


/* QCTMRLAT */

#define EQEP_QCTMRLAT_QCTMRLAT (0xFFFFu)
#define EQEP_QCTMRLAT_QCTMRLAT_SHIFT (0x0000u)


/* QCPRDLAT */

#define EQEP_QCPRDLAT_QCPDRLAT (0xFFFFu)
#define EQEP_QCPRDLAT_QCPDRLAT_SHIFT (0x0000u)


/* REVID */

#define EQEP_REVID_REV          (0xFFFFFFFFu)
#define EQEP_REVID_REV_SHIFT         (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif
