

/**
 *  @Component:   PRM
 *
 *  @Filename:    ../../CredDataBase/prcmCRED/prm_device_cred.h
 *
 ============================================================================ */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


#ifndef _HW_PRM_DEVICE_H_
#define _HW_PRM_DEVICE_H_


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define PRM_DEVICE_PRM_RSTCTRL   (0x0)
#define PRM_DEVICE_PRM_RSTTIME   (0x4)
#define PRM_DEVICE_PRM_RSTST   (0x8)
#define PRM_DEVICE_PRM_SRAM_COUNT   (0xc)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP   (0x10)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL   (0x14)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP   (0x18)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL   (0x1c)

/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/* PRM_RSTCTRL */
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_COLD_SW   (0x00000002u)
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_COLD_SW_SHIFT   (0x00000001u)
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_COLD_SW_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_COLD_SW_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_WARM_SW   (0x00000001u)
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_WARM_SW_SHIFT   (0x00000000u)
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_WARM_SW_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTCTRL_RST_GLOBAL_WARM_SW_0X1   (0x1u)


/* PRM_RSTTIME */
#define PRM_DEVICE_PRM_RSTTIME_RSTTIME1   (0x000000FFu)
#define PRM_DEVICE_PRM_RSTTIME_RSTTIME1_SHIFT   (0x00000000u)

#define PRM_DEVICE_PRM_RSTTIME_RSTTIME2   (0x00001F00u)
#define PRM_DEVICE_PRM_RSTTIME_RSTTIME2_SHIFT   (0x00000008u)


/* PRM_RSTST */
#define PRM_DEVICE_PRM_RSTST_EXTERNAL_WARM_RST   (0x00000020u)
#define PRM_DEVICE_PRM_RSTST_EXTERNAL_WARM_RST_SHIFT   (0x00000005u)
#define PRM_DEVICE_PRM_RSTST_EXTERNAL_WARM_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_EXTERNAL_WARM_RST_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTST_GLOBAL_COLD_RST   (0x00000001u)
#define PRM_DEVICE_PRM_RSTST_GLOBAL_COLD_RST_SHIFT   (0x00000000u)
#define PRM_DEVICE_PRM_RSTST_GLOBAL_COLD_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_GLOBAL_COLD_RST_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTST_GLOBAL_WARM_SW_RST   (0x00000002u)
#define PRM_DEVICE_PRM_RSTST_GLOBAL_WARM_SW_RST_SHIFT   (0x00000001u)
#define PRM_DEVICE_PRM_RSTST_GLOBAL_WARM_SW_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_GLOBAL_WARM_SW_RST_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTST_ICEPICK_RST   (0x00000200u)
#define PRM_DEVICE_PRM_RSTST_ICEPICK_RST_SHIFT   (0x00000009u)
#define PRM_DEVICE_PRM_RSTST_ICEPICK_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_ICEPICK_RST_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTST_MPU_SECURITY_VIOL_RST   (0x00000004u)
#define PRM_DEVICE_PRM_RSTST_MPU_SECURITY_VIOL_RST_SHIFT   (0x00000002u)
#define PRM_DEVICE_PRM_RSTST_MPU_SECURITY_VIOL_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_MPU_SECURITY_VIOL_RST_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTST_WDT0_RST   (0x00000008u)
#define PRM_DEVICE_PRM_RSTST_WDT0_RST_SHIFT   (0x00000003u)
#define PRM_DEVICE_PRM_RSTST_WDT0_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_WDT0_RST_0X1   (0x1u)

#define PRM_DEVICE_PRM_RSTST_WDT1_RST   (0x00000010u)
#define PRM_DEVICE_PRM_RSTST_WDT1_RST_SHIFT   (0x00000004u)
#define PRM_DEVICE_PRM_RSTST_WDT1_RST_0X0   (0x0u)
#define PRM_DEVICE_PRM_RSTST_WDT1_RST_0X1   (0x1u)


/* PRM_SRAM_COUNT */
#define PRM_DEVICE_PRM_SRAM_COUNT_PCHARGECNT_VALUE   (0x0000003Fu)
#define PRM_DEVICE_PRM_SRAM_COUNT_PCHARGECNT_VALUE_SHIFT   (0x00000000u)

#define PRM_DEVICE_PRM_SRAM_COUNT_SLPCNT_VALUE   (0x00FF0000u)
#define PRM_DEVICE_PRM_SRAM_COUNT_SLPCNT_VALUE_SHIFT   (0x00000010u)

#define PRM_DEVICE_PRM_SRAM_COUNT_STARTUP_COUNT   (0xFF000000u)
#define PRM_DEVICE_PRM_SRAM_COUNT_STARTUP_COUNT_SHIFT   (0x00000018u)

#define PRM_DEVICE_PRM_SRAM_COUNT_VSETUPCNT_VALUE   (0x0000FF00u)
#define PRM_DEVICE_PRM_SRAM_COUNT_VSETUPCNT_VALUE_SHIFT   (0x00000008u)


/* PRM_LDO_SRAM_CORE_SETUP */
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_ACT_EXPORT   (0x00000002u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_ACT_EXPORT_SHIFT   (0x00000001u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_ACT_EXPORT_SRAMNW_ACT_VDDAR   (0x1u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_ACT_EXPORT_SRAMNW_ACT_VDDS   (0x0u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_SLEEP_EXPORT   (0x00000004u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_SLEEP_EXPORT_SHIFT   (0x00000002u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_SLEEP_EXPORT_SRAMNW_SLP_VDDAR   (0x1u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ABBOFF_SLEEP_EXPORT_SRAMNW_SLP_VDDS   (0x0u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_AIPOFF   (0x00000100u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_AIPOFF_SHIFT   (0x00000008u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_AIPOFF_NO_OVERRIDE   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_AIPOFF_OVERRIDE   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_DISABLE_RTA_EXPORT   (0x00000001u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_DISABLE_RTA_EXPORT_SHIFT   (0x00000000u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_DISABLE_RTA_EXPORT_RTA_DISABLED   (0x1u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_DISABLE_RTA_EXPORT_RTA_ENABLED   (0x0u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC1_EXPORT   (0x00000008u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC1_EXPORT_SHIFT   (0x00000003u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC1_EXPORT_SHORT_PROT_DISABLED   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC1_EXPORT_SHORT_PROT_ENABLED   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC2_EXPORT   (0x00000010u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC2_EXPORT_SHIFT   (0x00000004u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC2_EXPORT_EXT_CAP   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC2_EXPORT_NO_EXT_CAP   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC3_EXPORT   (0x00000020u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC3_EXPORT_SHIFT   (0x00000005u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC3_EXPORT_SUB_REGUL_DISABLED   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC3_EXPORT_SUB_REGUL_ENABLED   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC4   (0x00000040u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC4_SHIFT   (0x00000006u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC4_EXT_CLOCK   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC4_NO_EXT_CLOCK   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC5   (0x00000080u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC5_SHIFT   (0x00000007u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC5_ONE_STEP   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_SETUP_ENFUNC5_TWO_STEP   (0x1u)


/* PRM_LDO_SRAM_CORE_CTRL */
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_RETMODE_ENABLE   (0x00000001u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_RETMODE_ENABLE_SHIFT   (0x00000000u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_RETMODE_ENABLE_DISABLED   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_RETMODE_ENABLE_ENABLED   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAMLDO_STATUS   (0x00000100u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAMLDO_STATUS_SHIFT   (0x00000008u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAMLDO_STATUS_ACTIVE   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAMLDO_STATUS_RETENTION   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAM_IN_TRANSITION   (0x00000200u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAM_IN_TRANSITION_SHIFT   (0x00000009u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAM_IN_TRANSITION_IDLE   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_CORE_CTRL_SRAM_IN_TRANSITION_IN_TRANSITION   (0x1u)


/* PRM_LDO_SRAM_MPU_SETUP */
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_ACT_EXPORT   (0x00000002u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_ACT_EXPORT_SHIFT   (0x00000001u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_ACT_EXPORT_SRAMNW_ACT_VDDAR   (0x1u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_ACT_EXPORT_SRAMNW_ACT_VDDS   (0x0u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_SLEEP_EXPORT   (0x00000004u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_SLEEP_EXPORT_SHIFT   (0x00000002u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_SLEEP_EXPORT_SRAMNW_SLP_VDDAR   (0x1u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ABBOFF_SLEEP_EXPORT_SRAMNW_SLP_VDDS   (0x0u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_AIPOFF   (0x00000100u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_AIPOFF_SHIFT   (0x00000008u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_AIPOFF_NO_OVERRIDE   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_AIPOFF_OVERRIDE   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_DISABLE_RTA_EXPORT   (0x00000001u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_DISABLE_RTA_EXPORT_SHIFT   (0x00000000u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_DISABLE_RTA_EXPORT_RTA_DISABLED   (0x1u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_DISABLE_RTA_EXPORT_RTA_ENABLED   (0x0u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC1_EXPORT   (0x00000008u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC1_EXPORT_SHIFT   (0x00000003u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC1_EXPORT_SHORT_PROT_DISABLED   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC1_EXPORT_SHORT_PROT_ENABLED   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC2_EXPORT   (0x00000010u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC2_EXPORT_SHIFT   (0x00000004u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC2_EXPORT_EXT_CAP   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC2_EXPORT_NO_EXT_CAP   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC3_EXPORT   (0x00000020u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC3_EXPORT_SHIFT   (0x00000005u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC3_EXPORT_SUB_REGUL_DISABLED   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC3_EXPORT_SUB_REGUL_ENABLED   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC4   (0x00000040u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC4_SHIFT   (0x00000006u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC4_EXT_CLOCK   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC4_NO_EXT_CLOCK   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC5   (0x00000080u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC5_SHIFT   (0x00000007u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC5_ONE_STEP   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_SETUP_ENFUNC5_TWO_STEP   (0x1u)


/* PRM_LDO_SRAM_MPU_CTRL */
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_RETMODE_ENABLE   (0x00000001u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_RETMODE_ENABLE_SHIFT   (0x00000000u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_RETMODE_ENABLE_DISABLED   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_RETMODE_ENABLE_ENABLED   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAMLDO_STATUS   (0x00000100u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAMLDO_STATUS_SHIFT   (0x00000008u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAMLDO_STATUS_ACTIVE   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAMLDO_STATUS_RETENTION   (0x1u)

#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAM_IN_TRANSITION   (0x00000200u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAM_IN_TRANSITION_SHIFT   (0x00000009u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAM_IN_TRANSITION_IDLE   (0x0u)
#define PRM_DEVICE_PRM_LDO_SRAM_MPU_CTRL_SRAM_IN_TRANSITION_IN_TRANSITION   (0x1u)



#endif
