/*
 * Copyright (c) 2001-2003 Swedish Institute of Computer Science.
 * All rights reserved. 
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Author: Adam Dunkels <adam@sics.se>
 *
 */
#include "lwip/def.h"
#include "fs.h"
#include "fsdata.h"

#if defined(evmAM1808) || defined(evmOMAPL138) || defined(evmC6748) \
    || defined(lcdkOMAPL138) || defined(lcdkC6748)
#include "fsdata_evmAM1808.c"
#endif
#if defined(evmAM335x)
#include "fsdata_evmAM335x.c"
#endif
#if defined(beaglebone)
#include "fsdata_beaglebone.c"
#endif
#if defined(evmC6A811x)
#include "fsdata_evmC6A811x.c"
#endif
#if defined(MityDSPL138)
#include "fsdata_MityDSPL138.c"
#endif

#include <string.h>

/** Search for a file by its full name and return pointer and length if found.
 *
 * @param name full file name as passed in HTTP request
 * @param file structure that must be allocated by caller and will be filled in
 *        by the function if the filename was found.
 * @return 1 if the file was found, 0 if the file was not found
 */
int
fs_open(const char *name, struct fs_file *file)
{
  const struct fsdata_file *f;

  for (f = FS_ROOT; f != NULL; f = f->next) {
    if (!strcmp(name, (const char*)f->name)) {
      file->data = f->data;
      file->len = f->len;
      return 1;
    }
  }
  return 0;
}
