

/**
 *  @Component:   CPSW
 *
 *  @Filename:    cpsw_port_cred.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_CPSW_PORT_H_
#define _HW_CPSW_PORT_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CPSW_PORT_CONTROL   (0x0)
#define CPSW_PORT_MAX_BLKS   (0x8)
#define CPSW_PORT_BLK_CNT   (0xc)
#define CPSW_PORT_TX_IN_CTL   (0x10)
#define CPSW_PORT_PORT_VLAN   (0x14)
#define CPSW_PORT_TX_PRI_MAP   (0x18)
#define CPSW_PORT_CPDMA_TX_PRI_MAP0   (0x1c)
#define CPSW_PORT_CPDMA_RX_CH_MAP0   (0x20)
#define CPSW_PORT_RX_DSCP_PRI_MAP(n)   (0x30 + (n * 4))
#define CPSW_PORT_TS_SEQ_MTYPE   (0x1c)
#define CPSW_PORT_SA_LO  (0x20)
#define CPSW_PORT_SA_HI   (0x24)
#define CPSW_PORT_SEND_PERCENT   (0x28)

/**************************************************************************\
 * Field Definition Macros
\**************************************************************************/

/* P0_CONTROL */
#define CPSW_PORT_P0_CONTROL_P0_DLR_CPDMA_CH   (0x70000000u)
#define CPSW_PORT_P0_CONTROL_P0_DLR_CPDMA_CH_SHIFT   (0x0000001Cu)

#define CPSW_PORT_P0_CONTROL_P0_DSCP_PRI_EN   (0x00010000u)
#define CPSW_PORT_P0_CONTROL_P0_DSCP_PRI_EN_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_CONTROL_P0_PASS_PRI_TAGGED   (0x01000000u)
#define CPSW_PORT_P0_CONTROL_P0_PASS_PRI_TAGGED_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_CONTROL_P0_VLAN_LTYPE1_EN   (0x00100000u)
#define CPSW_PORT_P0_CONTROL_P0_VLAN_LTYPE1_EN_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_CONTROL_P0_VLAN_LTYPE2_EN   (0x00200000u)
#define CPSW_PORT_P0_CONTROL_P0_VLAN_LTYPE2_EN_SHIFT   (0x00000015u)


/* P0_MAX_BLKS */
#define CPSW_PORT_P0_MAX_BLKS_P0_RX_MAX_BLKS   (0x0000000Fu)
#define CPSW_PORT_P0_MAX_BLKS_P0_RX_MAX_BLKS_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_MAX_BLKS_P0_TX_MAX_BLKS   (0x000001F0u)
#define CPSW_PORT_P0_MAX_BLKS_P0_TX_MAX_BLKS_SHIFT   (0x00000004u)


/* P0_BLK_CNT */
#define CPSW_PORT_P0_BLK_CNT_P0_RX_BLK_CNT   (0x0000000Fu)
#define CPSW_PORT_P0_BLK_CNT_P0_RX_BLK_CNT_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_BLK_CNT_P0_TX_BLK_CNT   (0x000001F0u)
#define CPSW_PORT_P0_BLK_CNT_P0_TX_BLK_CNT_SHIFT   (0x00000004u)


/* P0_TX_IN_CTL */
#define CPSW_PORT_P0_TX_IN_CTL_TX_BLKS_REM   (0x0000F000u)
#define CPSW_PORT_P0_TX_IN_CTL_TX_BLKS_REM_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_TX_IN_CTL_TX_IN_SEL   (0x00030000u)
#define CPSW_PORT_P0_TX_IN_CTL_TX_IN_SEL_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_TX_IN_CTL_TX_PRI_WDS   (0x000003FFu)
#define CPSW_PORT_P0_TX_IN_CTL_TX_PRI_WDS_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_TX_IN_CTL_TX_RATE_EN   (0x00F00000u)
#define CPSW_PORT_P0_TX_IN_CTL_TX_RATE_EN_SHIFT   (0x00000014u)


/* P0_PORT_VLAN */
#define CPSW_PORT_P0_PORT_VLAN_PORT_CFI   (0x00001000u)
#define CPSW_PORT_P0_PORT_VLAN_PORT_CFI_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_PORT_VLAN_PORT_PRI   (0x0000E000u)
#define CPSW_PORT_P0_PORT_VLAN_PORT_PRI_SHIFT   (0x0000000Du)

#define CPSW_PORT_P0_PORT_VLAN_PORT_VID   (0x00000FFFu)
#define CPSW_PORT_P0_PORT_VLAN_PORT_VID_SHIFT   (0x00000000u)


/* P0_TX_PRI_MAP */
#define CPSW_PORT_P0_TX_PRI_MAP_PRI0   (0x00000003u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI1   (0x00000030u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI2   (0x00000300u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI3   (0x00003000u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI4   (0x00030000u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI5   (0x00300000u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI6   (0x03000000u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_TX_PRI_MAP_PRI7   (0x30000000u)
#define CPSW_PORT_P0_TX_PRI_MAP_PRI7_SHIFT   (0x0000001Cu)


/* P0_CPDMA_TX_PRI_MAP */
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI0   (0x00000007u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI1   (0x00000070u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI2   (0x00000700u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI3   (0x00007000u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI4   (0x00070000u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI5   (0x00700000u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI6   (0x07000000u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI7   (0x70000000u)
#define CPSW_PORT_P0_CPDMA_TX_PRI_MAP_PRI7_SHIFT   (0x0000001Cu)


/* P0_CPDMA_RX_CH_MAP */
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI0   (0x00000007u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI1   (0x00000070u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI2   (0x00000700u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI3   (0x00007000u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P1_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI0   (0x00070000u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI0_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI1   (0x00700000u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI1_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI2   (0x07000000u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI2_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI3   (0x70000000u)
#define CPSW_PORT_P0_CPDMA_RX_CH_MAP_P2_PRI3_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP0 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI0   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI1   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI2   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI3   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI4   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI5   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI6   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI7   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP0_PRI7_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP1 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI10   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI10_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI11   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI11_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI12   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI12_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI13   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI13_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI14   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI14_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI15   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI15_SHIFT   (0x0000001Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI8   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI8_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI9   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP1_PRI9_SHIFT   (0x00000004u)


/* P0_RX_DSCP_PRI_MAP2 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI16   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI16_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI17   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI17_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI18   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI18_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI19   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI19_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI20   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI20_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI21   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI21_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI22   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI22_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI23   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP2_PRI23_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP3 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI24   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI24_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI25   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI25_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI26   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI26_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI27   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI27_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI28   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI28_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI29   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI29_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI30   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI30_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI31   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP3_PRI31_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP4 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI32   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI32_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI33   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI33_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI34   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI34_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI35   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI35_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI36   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI36_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI37   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI37_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI38   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI38_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI39   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP4_PRI39_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP5 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI40   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI40_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI41   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI41_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI42   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI42_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI43   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI43_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI44   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI44_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI45   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI45_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI46   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI46_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI47   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP5_PRI47_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP6 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI48   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI48_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI49   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI49_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI50   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI50_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI51   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI51_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI52   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI52_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI53   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI53_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI54   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI54_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI55   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP6_PRI55_SHIFT   (0x0000001Cu)


/* P0_RX_DSCP_PRI_MAP7 */
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI56   (0x00000007u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI56_SHIFT   (0x00000000u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI57   (0x00000070u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI57_SHIFT   (0x00000004u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI58   (0x00000700u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI58_SHIFT   (0x00000008u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI59   (0x00007000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI59_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI60   (0x00070000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI60_SHIFT   (0x00000010u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI61   (0x00700000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI61_SHIFT   (0x00000014u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI62   (0x07000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI62_SHIFT   (0x00000018u)

#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI63   (0x70000000u)
#define CPSW_PORT_P0_RX_DSCP_PRI_MAP7_PRI63_SHIFT   (0x0000001Cu)


/* P1_CONTROL */
#define CPSW_PORT_P1_CONTROL_P1_DSCP_PRI_EN   (0x00010000u)
#define CPSW_PORT_P1_CONTROL_P1_DSCP_PRI_EN_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_CONTROL_P1_PASS_PRI_TAGGED   (0x01000000u)
#define CPSW_PORT_P1_CONTROL_P1_PASS_PRI_TAGGED_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_CONTROL_P1_TS_129   (0x00000200u)
#define CPSW_PORT_P1_CONTROL_P1_TS_129_SHIFT   (0x00000009u)

#define CPSW_PORT_P1_CONTROL_P1_TS_130   (0x00000400u)
#define CPSW_PORT_P1_CONTROL_P1_TS_130_SHIFT   (0x0000000Au)

#define CPSW_PORT_P1_CONTROL_P1_TS_131   (0x00000800u)
#define CPSW_PORT_P1_CONTROL_P1_TS_131_SHIFT   (0x0000000Bu)

#define CPSW_PORT_P1_CONTROL_P1_TS_132   (0x00001000u)
#define CPSW_PORT_P1_CONTROL_P1_TS_132_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_CONTROL_P1_TS_319   (0x00002000u)
#define CPSW_PORT_P1_CONTROL_P1_TS_319_SHIFT   (0x0000000Du)

#define CPSW_PORT_P1_CONTROL_P1_TS_320   (0x00004000u)
#define CPSW_PORT_P1_CONTROL_P1_TS_320_SHIFT   (0x0000000Eu)

#define CPSW_PORT_P1_CONTROL_P1_TS_ANNEX_D_EN   (0x00000010u)
#define CPSW_PORT_P1_CONTROL_P1_TS_ANNEX_D_EN_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_CONTROL_P1_TS_LTYPE1_EN   (0x00000004u)
#define CPSW_PORT_P1_CONTROL_P1_TS_LTYPE1_EN_SHIFT   (0x00000002u)

#define CPSW_PORT_P1_CONTROL_P1_TS_LTYPE2_EN   (0x00000008u)
#define CPSW_PORT_P1_CONTROL_P1_TS_LTYPE2_EN_SHIFT   (0x00000003u)

#define CPSW_PORT_P1_CONTROL_P1_TS_RX_EN   (0x00000001u)
#define CPSW_PORT_P1_CONTROL_P1_TS_RX_EN_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_CONTROL_P1_TS_TX_EN   (0x00000002u)
#define CPSW_PORT_P1_CONTROL_P1_TS_TX_EN_SHIFT   (0x00000001u)

#define CPSW_PORT_P1_CONTROL_P1_VLAN_LTYPE1_EN   (0x00100000u)
#define CPSW_PORT_P1_CONTROL_P1_VLAN_LTYPE1_EN_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_CONTROL_P1_VLAN_LTYPE2_EN   (0x00200000u)
#define CPSW_PORT_P1_CONTROL_P1_VLAN_LTYPE2_EN_SHIFT   (0x00000015u)


/* P1_MAX_BLKS */
#define CPSW_PORT_P1_MAX_BLKS_P1_RX_MAX_BLKS   (0x0000000Fu)
#define CPSW_PORT_P1_MAX_BLKS_P1_RX_MAX_BLKS_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_MAX_BLKS_P1_TX_MAX_BLKS   (0x000001F0u)
#define CPSW_PORT_P1_MAX_BLKS_P1_TX_MAX_BLKS_SHIFT   (0x00000004u)


/* P1_BLK_CNT */
#define CPSW_PORT_P1_BLK_CNT_P1_RX_BLK_CNT   (0x0000000Fu)
#define CPSW_PORT_P1_BLK_CNT_P1_RX_BLK_CNT_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_BLK_CNT_P1_TX_BLK_CNT   (0x000001F0u)
#define CPSW_PORT_P1_BLK_CNT_P1_TX_BLK_CNT_SHIFT   (0x00000004u)


/* P1_TX_IN_CTL */
#define CPSW_PORT_P1_TX_IN_CTL_HOST_BLKS_REM   (0x0F000000u)
#define CPSW_PORT_P1_TX_IN_CTL_HOST_BLKS_REM_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_TX_IN_CTL_TX_BLKS_REM   (0x0000F000u)
#define CPSW_PORT_P1_TX_IN_CTL_TX_BLKS_REM_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_TX_IN_CTL_TX_IN_SEL   (0x00030000u)
#define CPSW_PORT_P1_TX_IN_CTL_TX_IN_SEL_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_TX_IN_CTL_TX_PRI_WDS   (0x000003FFu)
#define CPSW_PORT_P1_TX_IN_CTL_TX_PRI_WDS_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_TX_IN_CTL_TX_RATE_EN   (0x00F00000u)
#define CPSW_PORT_P1_TX_IN_CTL_TX_RATE_EN_SHIFT   (0x00000014u)


/* P1_PORT_VLAN */
#define CPSW_PORT_P1_PORT_VLAN_PORT_CFI   (0x00001000u)
#define CPSW_PORT_P1_PORT_VLAN_PORT_CFI_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_PORT_VLAN_PORT_PRI   (0x0000E000u)
#define CPSW_PORT_P1_PORT_VLAN_PORT_PRI_SHIFT   (0x0000000Du)

#define CPSW_PORT_P1_PORT_VLAN_PORT_VID   (0x00000FFFu)
#define CPSW_PORT_P1_PORT_VLAN_PORT_VID_SHIFT   (0x00000000u)


/* P1_TX_PRI_MAP */
#define CPSW_PORT_P1_TX_PRI_MAP_PRI0   (0x00000003u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI1   (0x00000030u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI2   (0x00000300u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI3   (0x00003000u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI4   (0x00030000u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI5   (0x00300000u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI6   (0x03000000u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_TX_PRI_MAP_PRI7   (0x30000000u)
#define CPSW_PORT_P1_TX_PRI_MAP_PRI7_SHIFT   (0x0000001Cu)


/* P1_TS_SEQ_MTYPE */
#define CPSW_PORT_P1_TS_SEQ_MTYPE_P1_TS_MSG_TYPE_EN   (0x0000FFFFu)
#define CPSW_PORT_P1_TS_SEQ_MTYPE_P1_TS_MSG_TYPE_EN_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_TS_SEQ_MTYPE_P1_TS_SEQ_ID_OFFSET   (0x003F0000u)
#define CPSW_PORT_P1_TS_SEQ_MTYPE_P1_TS_SEQ_ID_OFFSET_SHIFT   (0x00000010u)


/* P1_SA_LO */
#define CPSW_PORT_P1_SA_LO_MACSRCADDR_15_8   (0x000000FFu)
#define CPSW_PORT_P1_SA_LO_MACSRCADDR_15_8_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_SA_LO_MACSRCADDR_7_0   (0x0000FF00u)
#define CPSW_PORT_P1_SA_LO_MACSRCADDR_7_0_SHIFT   (0x00000008u)


/* P1_SA_HI */
#define CPSW_PORT_P1_SA_HI_MACSRCADDR_23_16   (0xFF000000u)
#define CPSW_PORT_P1_SA_HI_MACSRCADDR_23_16_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_SA_HI_MACSRCADDR_31_24   (0x00FF0000u)
#define CPSW_PORT_P1_SA_HI_MACSRCADDR_31_24_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_SA_HI_MACSRCADDR_39_32   (0x0000FF00u)
#define CPSW_PORT_P1_SA_HI_MACSRCADDR_39_32_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_SA_HI_MACSRCADDR_47_40   (0x000000FFu)
#define CPSW_PORT_P1_SA_HI_MACSRCADDR_47_40_SHIFT   (0x00000000u)


/* P1_SEND_PERCENT */
#define CPSW_PORT_P1_SEND_PERCENT_PRI1_SEND_PERCENT   (0x0000007Fu)
#define CPSW_PORT_P1_SEND_PERCENT_PRI1_SEND_PERCENT_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_SEND_PERCENT_PRI2_SEND_PERCENT   (0x00007F00u)
#define CPSW_PORT_P1_SEND_PERCENT_PRI2_SEND_PERCENT_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_SEND_PERCENT_PRI3_SEND_PERCENT   (0x007F0000u)
#define CPSW_PORT_P1_SEND_PERCENT_PRI3_SEND_PERCENT_SHIFT   (0x00000010u)


/* P1_RX_DSCP_PRI_MAP0 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI0   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI1   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI2   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI3   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI4   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI5   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI6   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI7   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP0_PRI7_SHIFT   (0x0000001Cu)


/* P1_RX_DSCP_PRI_MAP1 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI10   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI10_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI11   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI11_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI12   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI12_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI13   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI13_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI14   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI14_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI15   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI15_SHIFT   (0x0000001Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI8   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI8_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI9   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP1_PRI9_SHIFT   (0x00000004u)


/* P1_RX_DSCP_PRI_MAP2 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI16   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI16_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI17   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI17_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI18   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI18_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI19   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI19_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI20   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI20_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI21   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI21_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI22   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI22_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI23   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP2_PRI23_SHIFT   (0x0000001Cu)


/* P1_RX_DSCP_PRI_MAP3 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI24   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI24_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI25   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI25_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI26   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI26_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI27   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI27_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI28   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI28_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI29   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI29_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI30   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI30_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI31   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP3_PRI31_SHIFT   (0x0000001Cu)


/* P1_RX_DSCP_PRI_MAP4 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI32   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI32_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI33   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI33_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI34   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI34_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI35   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI35_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI36   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI36_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI37   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI37_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI38   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI38_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI39   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP4_PRI39_SHIFT   (0x0000001Cu)


/* P1_RX_DSCP_PRI_MAP5 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI40   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI40_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI41   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI41_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI42   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI42_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI43   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI43_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI44   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI44_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI45   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI45_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI46   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI46_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI47   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP5_PRI47_SHIFT   (0x0000001Cu)


/* P1_RX_DSCP_PRI_MAP6 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI48   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI48_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI49   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI49_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI50   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI50_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI51   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI51_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI52   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI52_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI53   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI53_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI54   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI54_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI55   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP6_PRI55_SHIFT   (0x0000001Cu)


/* P1_RX_DSCP_PRI_MAP7 */
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI56   (0x00000007u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI56_SHIFT   (0x00000000u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI57   (0x00000070u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI57_SHIFT   (0x00000004u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI58   (0x00000700u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI58_SHIFT   (0x00000008u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI59   (0x00007000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI59_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI60   (0x00070000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI60_SHIFT   (0x00000010u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI61   (0x00700000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI61_SHIFT   (0x00000014u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI62   (0x07000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI62_SHIFT   (0x00000018u)

#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI63   (0x70000000u)
#define CPSW_PORT_P1_RX_DSCP_PRI_MAP7_PRI63_SHIFT   (0x0000001Cu)


/* P2_CONTROL */
#define CPSW_PORT_P2_CONTROL_P2_DSCP_PRI_EN   (0x00010000u)
#define CPSW_PORT_P2_CONTROL_P2_DSCP_PRI_EN_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_CONTROL_P2_PASS_PRI_TAGGED   (0x01000000u)
#define CPSW_PORT_P2_CONTROL_P2_PASS_PRI_TAGGED_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_CONTROL_P2_TS_129   (0x00080000u)
#define CPSW_PORT_P2_CONTROL_P2_TS_129_SHIFT   (0x00000013u)

#define CPSW_PORT_P2_CONTROL_P2_TS_130   (0x00000400u)
#define CPSW_PORT_P2_CONTROL_P2_TS_130_SHIFT   (0x0000000Au)

#define CPSW_PORT_P2_CONTROL_P2_TS_131   (0x00000800u)
#define CPSW_PORT_P2_CONTROL_P2_TS_131_SHIFT   (0x0000000Bu)

#define CPSW_PORT_P2_CONTROL_P2_TS_132   (0x00001000u)
#define CPSW_PORT_P2_CONTROL_P2_TS_132_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_CONTROL_P2_TS_319   (0x00002000u)
#define CPSW_PORT_P2_CONTROL_P2_TS_319_SHIFT   (0x0000000Du)

#define CPSW_PORT_P2_CONTROL_P2_TS_320   (0x00004000u)
#define CPSW_PORT_P2_CONTROL_P2_TS_320_SHIFT   (0x0000000Eu)

#define CPSW_PORT_P2_CONTROL_P2_TS_ANNEX_D_EN   (0x00000010u)
#define CPSW_PORT_P2_CONTROL_P2_TS_ANNEX_D_EN_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_CONTROL_P2_TS_LTYPE1_EN   (0x00000004u)
#define CPSW_PORT_P2_CONTROL_P2_TS_LTYPE1_EN_SHIFT   (0x00000002u)

#define CPSW_PORT_P2_CONTROL_P2_TS_LTYPE2_EN   (0x00000008u)
#define CPSW_PORT_P2_CONTROL_P2_TS_LTYPE2_EN_SHIFT   (0x00000003u)

#define CPSW_PORT_P2_CONTROL_P2_TS_RX_EN   (0x00000001u)
#define CPSW_PORT_P2_CONTROL_P2_TS_RX_EN_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_CONTROL_P2_TS_TX_EN   (0x00000002u)
#define CPSW_PORT_P2_CONTROL_P2_TS_TX_EN_SHIFT   (0x00000001u)

#define CPSW_PORT_P2_CONTROL_P2_VLAN_LTYPE1_EN   (0x00100000u)
#define CPSW_PORT_P2_CONTROL_P2_VLAN_LTYPE1_EN_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_CONTROL_P2_VLAN_LTYPE2_EN   (0x00200000u)
#define CPSW_PORT_P2_CONTROL_P2_VLAN_LTYPE2_EN_SHIFT   (0x00000015u)


/* P2_MAX_BLKS */
#define CPSW_PORT_P2_MAX_BLKS_P2_RX_MAX_BLKS   (0x0000000Fu)
#define CPSW_PORT_P2_MAX_BLKS_P2_RX_MAX_BLKS_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_MAX_BLKS_P2_TX_MAX_BLKS   (0x000001F0u)
#define CPSW_PORT_P2_MAX_BLKS_P2_TX_MAX_BLKS_SHIFT   (0x00000004u)


/* P2_BLK_CNT */
#define CPSW_PORT_P2_BLK_CNT_P2_RX_BLK_CNT   (0x0000000Fu)
#define CPSW_PORT_P2_BLK_CNT_P2_RX_BLK_CNT_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_BLK_CNT_P2_TX_BLK_CNT   (0x000001F0u)
#define CPSW_PORT_P2_BLK_CNT_P2_TX_BLK_CNT_SHIFT   (0x00000004u)


/* P2_TX_IN_CTL */
#define CPSW_PORT_P2_TX_IN_CTL_HOST_BLKS_REM   (0x0F000000u)
#define CPSW_PORT_P2_TX_IN_CTL_HOST_BLKS_REM_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_TX_IN_CTL_TX_BLKS_REM   (0x0000F000u)
#define CPSW_PORT_P2_TX_IN_CTL_TX_BLKS_REM_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_TX_IN_CTL_TX_IN_SEL   (0x00030000u)
#define CPSW_PORT_P2_TX_IN_CTL_TX_IN_SEL_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_TX_IN_CTL_TX_PRI_WDS   (0x000003FFu)
#define CPSW_PORT_P2_TX_IN_CTL_TX_PRI_WDS_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_TX_IN_CTL_TX_RATE_EN   (0x00F00000u)
#define CPSW_PORT_P2_TX_IN_CTL_TX_RATE_EN_SHIFT   (0x00000014u)


/* P2_PORT_VLAN */
#define CPSW_PORT_P2_PORT_VLAN_PORT_CFI   (0x00001000u)
#define CPSW_PORT_P2_PORT_VLAN_PORT_CFI_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_PORT_VLAN_PORT_PRI   (0x0000E000u)
#define CPSW_PORT_P2_PORT_VLAN_PORT_PRI_SHIFT   (0x0000000Du)

#define CPSW_PORT_P2_PORT_VLAN_PORT_VID   (0x00000FFFu)
#define CPSW_PORT_P2_PORT_VLAN_PORT_VID_SHIFT   (0x00000000u)


/* P2_TX_PRI_MAP */
#define CPSW_PORT_P2_TX_PRI_MAP_PRI0   (0x00000003u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI1   (0x00000030u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI2   (0x00000300u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI3   (0x00003000u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI4   (0x00030000u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI5   (0x00300000u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI6   (0x03000000u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_TX_PRI_MAP_PRI7   (0x30000000u)
#define CPSW_PORT_P2_TX_PRI_MAP_PRI7_SHIFT   (0x0000001Cu)


/* P2_TS_SEQ_MTYPE */
#define CPSW_PORT_P2_TS_SEQ_MTYPE_P2_TS_MSG_TYPE_EN   (0x0000FFFFu)
#define CPSW_PORT_P2_TS_SEQ_MTYPE_P2_TS_MSG_TYPE_EN_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_TS_SEQ_MTYPE_P2_TS_SEQ_ID_OFFSET   (0x003F0000u)
#define CPSW_PORT_P2_TS_SEQ_MTYPE_P2_TS_SEQ_ID_OFFSET_SHIFT   (0x00000010u)


/* P2_SA_LO */
#define CPSW_PORT_P2_SA_LO_MACSRCADDR_15_8   (0x000000FFu)
#define CPSW_PORT_P2_SA_LO_MACSRCADDR_15_8_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_SA_LO_MACSRCADDR_7_0   (0x0000FF00u)
#define CPSW_PORT_P2_SA_LO_MACSRCADDR_7_0_SHIFT   (0x00000008u)


/* P2_SA_HI */
#define CPSW_PORT_P2_SA_HI_MACSRCADDR_23_16   (0xFF000000u)
#define CPSW_PORT_P2_SA_HI_MACSRCADDR_23_16_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_SA_HI_MACSRCADDR_31_23   (0x00FF0000u)
#define CPSW_PORT_P2_SA_HI_MACSRCADDR_31_23_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_SA_HI_MACSRCADDR_39_32   (0x0000FF00u)
#define CPSW_PORT_P2_SA_HI_MACSRCADDR_39_32_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_SA_HI_MACSRCADDR_47_40   (0x000000FFu)
#define CPSW_PORT_P2_SA_HI_MACSRCADDR_47_40_SHIFT   (0x00000000u)


/* P2_SEND_PERCENT */
#define CPSW_PORT_P2_SEND_PERCENT_PRI1_SEND_PERCENT   (0x0000007Fu)
#define CPSW_PORT_P2_SEND_PERCENT_PRI1_SEND_PERCENT_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_SEND_PERCENT_PRI2_SEND_PERCENT   (0x00007F00u)
#define CPSW_PORT_P2_SEND_PERCENT_PRI2_SEND_PERCENT_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_SEND_PERCENT_PRI3_SEND_PERCENT   (0x007F0000u)
#define CPSW_PORT_P2_SEND_PERCENT_PRI3_SEND_PERCENT_SHIFT   (0x00000010u)


/* P2_RX_DSCP_PRI_MAP0 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI0   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI0_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI1   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI1_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI2   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI2_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI3   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI3_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI4   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI4_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI5   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI5_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI6   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI6_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI7   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP0_PRI7_SHIFT   (0x0000001Cu)


/* P2_RX_DSCP_PRI_MAP1 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI10   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI10_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI11   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI11_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI12   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI12_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI13   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI13_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI14   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI14_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI15   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI15_SHIFT   (0x0000001Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI8   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI8_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI9   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP1_PRI9_SHIFT   (0x00000004u)


/* P2_RX_DSCP_PRI_MAP2 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI16   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI16_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI17   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI17_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI18   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI18_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI19   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI19_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI20   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI20_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI21   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI21_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI22   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI22_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI23   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP2_PRI23_SHIFT   (0x0000001Cu)


/* P2_RX_DSCP_PRI_MAP3 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI24   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI24_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI25   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI25_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI26   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI26_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI27   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI27_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI28   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI28_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI29   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI29_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI30   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI30_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI31   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP3_PRI31_SHIFT   (0x0000001Cu)


/* P2_RX_DSCP_PRI_MAP4 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI32   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI32_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI33   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI33_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI34   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI34_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI35   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI35_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI36   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI36_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI37   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI37_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI38   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI38_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI39   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP4_PRI39_SHIFT   (0x0000001Cu)


/* P2_RX_DSCP_PRI_MAP5 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI40   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI40_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI41   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI41_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI42   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI42_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI43   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI43_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI44   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI44_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI45   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI45_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI46   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI46_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI47   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP5_PRI47_SHIFT   (0x0000001Cu)


/* P2_RX_DSCP_PRI_MAP6 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI48   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI48_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI49   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI49_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI50   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI50_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI51   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI51_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI52   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI52_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI53   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI53_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI54   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI54_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI55   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP6_PRI55_SHIFT   (0x0000001Cu)


/* P2_RX_DSCP_PRI_MAP7 */
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI56   (0x00000007u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI56_SHIFT   (0x00000000u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI57   (0x00000070u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI57_SHIFT   (0x00000004u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI58   (0x00000700u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI58_SHIFT   (0x00000008u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI59   (0x00007000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI59_SHIFT   (0x0000000Cu)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI60   (0x00070000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI60_SHIFT   (0x00000010u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI61   (0x00700000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI61_SHIFT   (0x00000014u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI62   (0x07000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI62_SHIFT   (0x00000018u)

#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI63   (0x70000000u)
#define CPSW_PORT_P2_RX_DSCP_PRI_MAP7_PRI63_SHIFT   (0x0000001Cu)



#ifdef __cplusplus
}
#endif

#endif
