/**
 * \file  hw_usb_ohci.h
 *
 * \brief USB OHCI register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_OHCI_H_
#define _HW_OHCI_H_

#ifdef __cplusplus
extern "C" {
#endif

#define USB_OHCI_REVID			(0x0)
#define USB_OHCI_HCCONTROL		(0x4)
#define USB_OHCI_HCCOMMANDSTATUS	(0x8)
#define USB_OHCI_HCINTERRUPTSTATUS	(0xC)
#define USB_OHCI_HCINTERRUPTENABLE	(0x10)
#define USB_OHCI_HCINTERRUPTDISABLE	(0x14)
#define USB_OHCI_HCHCCA			(0x18)
#define USB_OHCI_HCPERIODCURRENTED	(0x1C)
#define USB_OHCI_HCCONTROLHEADED	(0x20)
#define USB_OHCI_HCCONTROLCURRENTED	(0x24)
#define USB_OHCI_HCBULKHEADED		(0x28)
#define USB_OHCI_HCBULKCURRENTED	(0x2C)
#define USB_OHCI_HCDONEHEAD		(0x30)
#define USB_OHCI_HCFMINTERVAL		(0x34)
#define USB_OHCI_HCFMREMAINING		(0x38)
#define USB_OHCI_HCFMNUMBER		(0x3C)
#define USB_OHCI_HCPERIODICSTART	(0x40)
#define USB_OHCI_HCLSTHRESHOLD		(0x44)
#define USB_OHCI_HCRHDESCRIPTORA	(0x48)
#define USB_OHCI_HCRHDESCRIPTORB	(0x4C)
#define USB_OHCI_HCRHSTATUS		(0x50)
#define USB_OHCI_HCRHPORTSTATUS1	(0x54)
#define USB_OHCI_HCRHPORTSTATUS2	(0x54)

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define OHCI_REVID_REV     (0xFFFFFFFFu)
#define OHCI_REVID_REV_SHIFT    (0x00000000u)


/* HcControl */

#define OHCI_HCCONTROL_RESERVED (0xFFFFF800u)
#define OHCI_HCCONTROL_RESERVED_SHIFT (0x0000000Bu)

#define OHCI_HCCONTROL_RWE      (0x00000400u)
#define OHCI_HCCONTROL_RWE_SHIFT     (0x0000000Au)

#define OHCI_HCCONTROL_RWC      (0x00000200u)
#define OHCI_HCCONTROL_RWC_SHIFT     (0x00000009u)

#define OHCI_HCCONTROL_IR       (0x00000100u)
#define OHCI_HCCONTROL_IR_SHIFT      (0x00000008u)

#define OHCI_HCCONTROL_HCFS     (0x000000C0u)
#define OHCI_HCCONTROL_HCFS_SHIFT    (0x00000006u)
/*----HCFS Tokens----*/
#define OHCI_HCCONTROL_HCFS_USBRESET (0x00000000u)
#define OHCI_HCCONTROL_HCFS_USBRESUME (0x00000001u)
#define OHCI_HCCONTROL_HCFS_USBOPERATIONAL (0x00000002u)
#define OHCI_HCCONTROL_HCFS_USBSUSPEND (0x00000003u)

#define OHCI_HCCONTROL_BLE      (0x00000020u)
#define OHCI_HCCONTROL_BLE_SHIFT     (0x00000005u)

#define OHCI_HCCONTROL_CLE      (0x00000010u)
#define OHCI_HCCONTROL_CLE_SHIFT     (0x00000004u)

#define OHCI_HCCONTROL_IE       (0x00000008u)
#define OHCI_HCCONTROL_IE_SHIFT      (0x00000003u)

#define OHCI_HCCONTROL_PLE      (0x00000004u)
#define OHCI_HCCONTROL_PLE_SHIFT     (0x00000002u)

#define OHCI_HCCONTROL_CBSR     (0x00000003u)
#define OHCI_HCCONTROL_CBSR_SHIFT    (0x00000000u)
/*----CBSR Tokens----*/
#define OHCI_HCCONTROL_CBSR_RATIO11  (0x00000000u)
#define OHCI_HCCONTROL_CBSR_RATIO21  (0x00000001u)
#define OHCI_HCCONTROL_CBSR_RATIO31  (0x00000002u)
#define OHCI_HCCONTROL_CBSR_RATIO41  (0x00000003u)


/* HcCommandStatus */

#define OHCI_HCCOMMANDSTATUS_SOC (0x00030000u)
#define OHCI_HCCOMMANDSTATUS_SOC_SHIFT (0x00000010u)

#define OHCI_HCCOMMANDSTATUS_OCR (0x00000008u)
#define OHCI_HCCOMMANDSTATUS_OCR_SHIFT (0x00000003u)

#define OHCI_HCCOMMANDSTATUS_BLF (0x00000004u)
#define OHCI_HCCOMMANDSTATUS_BLF_SHIFT (0x00000002u)

#define OHCI_HCCOMMANDSTATUS_CLF (0x00000002u)
#define OHCI_HCCOMMANDSTATUS_CLF_SHIFT (0x00000001u)

#define OHCI_HCCOMMANDSTATUS_HCR (0x00000001u)
#define OHCI_HCCOMMANDSTATUS_HCR_SHIFT (0x00000000u)


/* HcInterruptStatus */

#define OHCI_HCINTERRUPTSTATUS_RSVD (0x80000000u)
#define OHCI_HCINTERRUPTSTATUS_RSVD_SHIFT (0x0000001Fu)

#define OHCI_HCINTERRUPTSTATUS_OC (0x40000000u)
#define OHCI_HCINTERRUPTSTATUS_OC_SHIFT (0x0000001Eu)

#define OHCI_HCINTERRUPTSTATUS_RESERVED (0x3FFFFF80u)
#define OHCI_HCINTERRUPTSTATUS_RESERVED_SHIFT (0x00000007u)

#define OHCI_HCINTERRUPTSTATUS_RHSC (0x00000040u)
#define OHCI_HCINTERRUPTSTATUS_RHSC_SHIFT (0x00000006u)

#define OHCI_HCINTERRUPTSTATUS_FNO (0x00000020u)
#define OHCI_HCINTERRUPTSTATUS_FNO_SHIFT (0x00000005u)

#define OHCI_HCINTERRUPTSTATUS_UE (0x00000010u)
#define OHCI_HCINTERRUPTSTATUS_UE_SHIFT (0x00000004u)

#define OHCI_HCINTERRUPTSTATUS_RD (0x00000008u)
#define OHCI_HCINTERRUPTSTATUS_RD_SHIFT (0x00000003u)

#define OHCI_HCINTERRUPTSTATUS_SF (0x00000004u)
#define OHCI_HCINTERRUPTSTATUS_SF_SHIFT (0x00000002u)

#define OHCI_HCINTERRUPTSTATUS_WDH (0x00000002u)
#define OHCI_HCINTERRUPTSTATUS_WDH_SHIFT (0x00000001u)

#define OHCI_HCINTERRUPTSTATUS_SO (0x00000001u)
#define OHCI_HCINTERRUPTSTATUS_SO_SHIFT (0x00000000u)


/* HcInterruptEnable */

#define OHCI_HCINTERRUPTENABLE_MIE (0x80000000u)
#define OHCI_HCINTERRUPTENABLE_MIE_SHIFT (0x0000001Fu)

#define OHCI_HCINTERRUPTENABLE_OC (0x40000000u)
#define OHCI_HCINTERRUPTENABLE_OC_SHIFT (0x0000001Eu)

#define OHCI_HCINTERRUPTENABLE_RESERVED (0x3FFFFF80u)
#define OHCI_HCINTERRUPTENABLE_RESERVED_SHIFT (0x00000007u)

#define OHCI_HCINTERRUPTENABLE_RHSC (0x00000040u)
#define OHCI_HCINTERRUPTENABLE_RHSC_SHIFT (0x00000006u)

#define OHCI_HCINTERRUPTENABLE_FNO (0x00000020u)
#define OHCI_HCINTERRUPTENABLE_FNO_SHIFT (0x00000005u)

#define OHCI_HCINTERRUPTENABLE_UE (0x00000010u)
#define OHCI_HCINTERRUPTENABLE_UE_SHIFT (0x00000004u)

#define OHCI_HCINTERRUPTENABLE_RD (0x00000008u)
#define OHCI_HCINTERRUPTENABLE_RD_SHIFT (0x00000003u)

#define OHCI_HCINTERRUPTENABLE_SF (0x00000004u)
#define OHCI_HCINTERRUPTENABLE_SF_SHIFT (0x00000002u)

#define OHCI_HCINTERRUPTENABLE_WDH (0x00000002u)
#define OHCI_HCINTERRUPTENABLE_WDH_SHIFT (0x00000001u)

#define OHCI_HCINTERRUPTENABLE_SO (0x00000001u)
#define OHCI_HCINTERRUPTENABLE_SO_SHIFT (0x00000000u)


/* HcInterruptDisable */

#define OHCI_HCINTERRUPTDISABLE_MIE (0x80000000u)
#define OHCI_HCINTERRUPTDISABLE_MIE_SHIFT (0x0000001Fu)

#define OHCI_HCINTERRUPTDISABLE_OC (0x40000000u)
#define OHCI_HCINTERRUPTDISABLE_OC_SHIFT (0x0000001Eu)

#define OHCI_HCINTERRUPTDISABLE_RESERVED (0x3FFFFF80u)
#define OHCI_HCINTERRUPTDISABLE_RESERVED_SHIFT (0x00000007u)

#define OHCI_HCINTERRUPTDISABLE_RHSC (0x00000040u)
#define OHCI_HCINTERRUPTDISABLE_RHSC_SHIFT (0x00000006u)

#define OHCI_HCINTERRUPTDISABLE_FNO (0x00000020u)
#define OHCI_HCINTERRUPTDISABLE_FNO_SHIFT (0x00000005u)

#define OHCI_HCINTERRUPTDISABLE_UE (0x00000010u)
#define OHCI_HCINTERRUPTDISABLE_UE_SHIFT (0x00000004u)

#define OHCI_HCINTERRUPTDISABLE_RD (0x00000008u)
#define OHCI_HCINTERRUPTDISABLE_RD_SHIFT (0x00000003u)

#define OHCI_HCINTERRUPTDISABLE_SF (0x00000004u)
#define OHCI_HCINTERRUPTDISABLE_SF_SHIFT (0x00000002u)

#define OHCI_HCINTERRUPTDISABLE_WDH (0x00000002u)
#define OHCI_HCINTERRUPTDISABLE_WDH_SHIFT (0x00000001u)

#define OHCI_HCINTERRUPTDISABLE_SO (0x00000001u)
#define OHCI_HCINTERRUPTDISABLE_SO_SHIFT (0x00000000u)


/* HcHCCA */

#define OHCI_HCHCCA_HCCA        (0xFFFFFF00u)
#define OHCI_HCHCCA_HCCA_SHIFT       (0x00000008u)

#define OHCI_HCHCCA_RESERVED    (0x000000FFu)
#define OHCI_HCHCCA_RESERVED_SHIFT   (0x00000000u)


/* HcPeriodCurrentED */

#define OHCI_HCPERIODCURRENTED_PCED (0xFFFFFFF0u)
#define OHCI_HCPERIODCURRENTED_PCED_SHIFT (0x00000004u)

#define OHCI_HCPERIODCURRENTED_RESERVED (0x0000000Fu)
#define OHCI_HCPERIODCURRENTED_RESERVED_SHIFT (0x00000000u)


/* HcControlHeadED */

#define OHCI_HCCONTROLHEADED_CHED (0xFFFFFFF0u)
#define OHCI_HCCONTROLHEADED_CHED_SHIFT (0x00000004u)

#define OHCI_HCCONTROLHEADED_RESERVED (0x0000000Fu)
#define OHCI_HCCONTROLHEADED_RESERVED_SHIFT (0x00000000u)


/* HcControlCurrentED */

#define OHCI_HCCONTROLCURRENTED_CCED (0xFFFFFFF0u)
#define OHCI_HCCONTROLCURRENTED_CCED_SHIFT (0x00000004u)

#define OHCI_HCCONTROLCURRENTED_RESERVED (0x0000000Fu)
#define OHCI_HCCONTROLCURRENTED_RESERVED_SHIFT (0x00000000u)


/* HcBulkHeadED */

#define OHCI_HCBULKHEADED_BHED  (0xFFFFFFF0u)
#define OHCI_HCBULKHEADED_BHED_SHIFT (0x00000004u)

#define OHCI_HCBULKHEADED_RESERVED (0x0000000Fu)
#define OHCI_HCBULKHEADED_RESERVED_SHIFT (0x00000000u)


/* HcBulkCurrentED */

#define OHCI_HCBULKCURRENTED_BCED (0xFFFFFFF0u)
#define OHCI_HCBULKCURRENTED_BCED_SHIFT (0x00000004u)

#define OHCI_HCBULKCURRENTED_RESERVED (0x0000000Fu)
#define OHCI_HCBULKCURRENTED_RESERVED_SHIFT (0x00000000u)


/* HcDoneHead */

#define OHCI_HCDONEHEAD_DH      (0xFFFFFFF0u)
#define OHCI_HCDONEHEAD_DH_SHIFT     (0x00000004u)

#define OHCI_HCDONEHEAD_RESERVED (0x0000000Fu)
#define OHCI_HCDONEHEAD_RESERVED_SHIFT (0x00000000u)


/* HcFmInterval */

#define OHCI_HCFMINTERVAL_FIT   (0x80000000u)
#define OHCI_HCFMINTERVAL_FIT_SHIFT  (0x0000001Fu)

#define OHCI_HCFMINTERVAL_FSMPS (0x7FFF0000u)
#define OHCI_HCFMINTERVAL_FSMPS_SHIFT (0x00000010u)

#define OHCI_HCFMINTERVAL_RESERVED (0x0000C000u)
#define OHCI_HCFMINTERVAL_RESERVED_SHIFT (0x0000000Eu)

#define OHCI_HCFMINTERVAL_FRAMEINTERVAL (0x00003FFFu)
#define OHCI_HCFMINTERVAL_FRAMEINTERVAL_SHIFT (0x00000000u)


/* HcFmRemaining */

#define OHCI_HCFMREMAINING_FRT  (0x80000000u)
#define OHCI_HCFMREMAINING_FRT_SHIFT (0x0000001Fu)

#define OHCI_HCFMREMAINING_RESERVED (0x7FFFC000u)
#define OHCI_HCFMREMAINING_RESERVED_SHIFT (0x0000000Eu)

#define OHCI_HCFMREMAINING_FR   (0x00003FFFu)
#define OHCI_HCFMREMAINING_FR_SHIFT  (0x00000000u)


/* HcFmNumber */

#define OHCI_HCFMNUMBER_RESERVED (0xFFFF0000u)
#define OHCI_HCFMNUMBER_RESERVED_SHIFT (0x00000010u)

#define OHCI_HCFMNUMBER_FN      (0x0000FFFFu)
#define OHCI_HCFMNUMBER_FN_SHIFT     (0x00000000u)


/* HcPeriodicStart */

#define OHCI_HCPERIODICSTART_RESERVED (0xFFFFC000u)
#define OHCI_HCPERIODICSTART_RESERVED_SHIFT (0x0000000Eu)

#define OHCI_HCPERIODICSTART_PS (0x00003FFFu)
#define OHCI_HCPERIODICSTART_PS_SHIFT (0x00000000u)


/* HcLSThreshold */

#define OHCI_HCLSTHRESHOLD_RESERVED (0xFFFFF000u)
#define OHCI_HCLSTHRESHOLD_RESERVED_SHIFT (0x0000000Cu)

#define OHCI_HCLSTHRESHOLD_LST  (0x00000FFFu)
#define OHCI_HCLSTHRESHOLD_LST_SHIFT (0x00000000u)


/* HcRhDescriptorA */

#define OHCI_HCRHDESCRIPTORA_POTPGT (0xFF000000u)
#define OHCI_HCRHDESCRIPTORA_POTPGT_SHIFT (0x00000018u)

#define OHCI_HCRHDESCRIPTORA_RESERVED (0x00FFE000u)
#define OHCI_HCRHDESCRIPTORA_RESERVED_SHIFT (0x0000000Du)

#define OHCI_HCRHDESCRIPTORA_NOCP (0x00001000u)
#define OHCI_HCRHDESCRIPTORA_NOCP_SHIFT (0x0000000Cu)

#define OHCI_HCRHDESCRIPTORA_OCPM (0x00000800u)
#define OHCI_HCRHDESCRIPTORA_OCPM_SHIFT (0x0000000Bu)

#define OHCI_HCRHDESCRIPTORA_DT (0x00000400u)
#define OHCI_HCRHDESCRIPTORA_DT_SHIFT (0x0000000Au)

#define OHCI_HCRHDESCRIPTORA_NPS (0x00000200u)
#define OHCI_HCRHDESCRIPTORA_NPS_SHIFT (0x00000009u)

#define OHCI_HCRHDESCRIPTORA_PSM (0x00000100u)
#define OHCI_HCRHDESCRIPTORA_PSM_SHIFT (0x00000008u)

#define OHCI_HCRHDESCRIPTORA_NDP (0x000000FFu)
#define OHCI_HCRHDESCRIPTORA_NDP_SHIFT (0x00000000u)


/* HcRhDescriptorB */

#define OHCI_HCRHDESCRIPTORB_PPCM (0xFFFF0000u)
#define OHCI_HCRHDESCRIPTORB_PPCM_SHIFT (0x00000010u)

#define OHCI_HCRHDESCRIPTORB_DR (0x0000FFFFu)
#define OHCI_HCRHDESCRIPTORB_DR_SHIFT (0x00000000u)


/* HcRhStatus */

#define OHCI_HCRHSTATUS_CRWE    (0x80000000u)
#define OHCI_HCRHSTATUS_CRWE_SHIFT   (0x0000001Fu)

#define OHCI_HCRHSTATUS_OCIC    (0x00020000u)
#define OHCI_HCRHSTATUS_OCIC_SHIFT   (0x00000011u)

#define OHCI_HCRHSTATUS_LPSC    (0x00010000u)
#define OHCI_HCRHSTATUS_LPSC_SHIFT   (0x00000010u)

#define OHCI_HCRHSTATUS_DRWE    (0x00008000u)
#define OHCI_HCRHSTATUS_DRWE_SHIFT   (0x0000000Fu)

#define OHCI_HCRHSTATUS_RESERVED (0x00007FFCu)
#define OHCI_HCRHSTATUS_RESERVED_SHIFT (0x00000002u)

#define OHCI_HCRHSTATUS_OCI     (0x00000002u)
#define OHCI_HCRHSTATUS_OCI_SHIFT    (0x00000001u)

#define OHCI_HCRHSTATUS_LPS     (0x00000001u)
#define OHCI_HCRHSTATUS_LPS_SHIFT    (0x00000000u)


/* HcRhPortStatus */

#define OHCI_HCRHPORTSTATUS_PRSC (0x00100000u)
#define OHCI_HCRHPORTSTATUS_PRSC_SHIFT (0x00000014u)

#define OHCI_HCRHPORTSTATUS_OCIC (0x00080000u)
#define OHCI_HCRHPORTSTATUS_OCIC_SHIFT (0x00000013u)

#define OHCI_HCRHPORTSTATUS_PSSC (0x00040000u)
#define OHCI_HCRHPORTSTATUS_PSSC_SHIFT (0x00000012u)

#define OHCI_HCRHPORTSTATUS_PESC (0x00020000u)
#define OHCI_HCRHPORTSTATUS_PESC_SHIFT (0x00000011u)

#define OHCI_HCRHPORTSTATUS_CSC (0x00010000u)
#define OHCI_HCRHPORTSTATUS_CSC_SHIFT (0x00000010u)

#define OHCI_HCRHPORTSTATUS_LSDA (0x00000200u)
#define OHCI_HCRHPORTSTATUS_LSDA_SHIFT (0x00000009u)

#define OHCI_HCRHPORTSTATUS_PPS (0x00000100u)
#define OHCI_HCRHPORTSTATUS_PPS_SHIFT (0x00000008u)

#define OHCI_HCRHPORTSTATUS_PRS (0x00000010u)
#define OHCI_HCRHPORTSTATUS_PRS_SHIFT (0x00000004u)

#define OHCI_HCRHPORTSTATUS_POCI (0x00000008u)
#define OHCI_HCRHPORTSTATUS_POCI_SHIFT (0x00000003u)

#define OHCI_HCRHPORTSTATUS_PSS (0x00000004u)
#define OHCI_HCRHPORTSTATUS_PSS_SHIFT (0x00000002u)

#define OHCI_HCRHPORTSTATUS_PES (0x00000002u)
#define OHCI_HCRHPORTSTATUS_PES_SHIFT (0x00000001u)

#define OHCI_HCRHPORTSTATUS_CCS (0x00000001u)
#define OHCI_HCRHPORTSTATUS_CCS_SHIFT (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif
