# (C) 2001-2013 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# (C) 2001-2013 Altera Corporation. All rights reserved.
# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Altera Program License Subscription 
# Agreement, Altera MegaCore Function License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Altera and sold by 
# Altera or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# TCL File Generated by Component Editor 14.0
# Fri Sep 13 13:55:02 MYT 2013
# DO NOT MODIFY


# 
# altera_msi_to_gic_gen "altera_msi_to_gic_gen" v1.0
# shlim 2013.09.13.13:55:02
# Interrupt handler
# 

# 
# request TCL package from ACDS 14.0
# 
package require -exact qsys 13.0


# 
# module altera_msi_to_gic_gen
# 
set_module_property DESCRIPTION "This component allow level interrupt generation to the host processor upon arrival of MSI(Message Signaled Interrupts)"
set_module_property NAME altera_msi_to_gic_gen
set_module_property VERSION 1.0
set_module_property INTERNAL false
set_module_property OPAQUE_ADDRESS_MAP true
set_module_property GROUP "Peripherals/Multiprocessor Coordination"
set_module_property AUTHOR "Altera Corporation"
set_module_property DISPLAY_NAME "Altera MSI to GIC generator"
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property REPORT_TO_TALKBACK false
set_module_property ALLOW_GREYBOX_GENERATION false
set_module_property ELABORATION_CALLBACK "elaborate"
set_module_property VALIDATION_CALLBACK "validate"


# 
# file sets
# 
add_fileset QUARTUS_SYNTH QUARTUS_SYNTH "" ""
set_fileset_property QUARTUS_SYNTH TOP_LEVEL altera_msi_to_gic_gen
set_fileset_property QUARTUS_SYNTH ENABLE_RELATIVE_INCLUDE_PATHS false
add_fileset_file altera_msi_to_gic_gen.sv SYSTEM_VERILOG PATH ./altera_msi_to_gic_gen.sv TOP_LEVEL_FILE
add_fileset_file altera_msi_to_gic_gen_fifo.v VERILOG PATH ./altera_msi_to_gic_gen_fifo.v

add_fileset SIM_VERILOG SIM_VERILOG "" ""
set_fileset_property SIM_VERILOG TOP_LEVEL altera_msi_to_gic_gen
set_fileset_property SIM_VERILOG ENABLE_RELATIVE_INCLUDE_PATHS false
add_fileset_file altera_msi_to_gic_gen.sv SYSTEM_VERILOG PATH ./altera_msi_to_gic_gen.sv
add_fileset_file altera_msi_to_gic_gen_fifo.v VERILOG PATH ./altera_msi_to_gic_gen_fifo.v

add_fileset SIM_VHDL SIM_VHDL sim_callback_procedure_vhdl
set_fileset_property SIM_VHDL TOP_LEVEL altera_msi_to_gic_gen
set_fileset_property SIM_VHDL ENABLE_RELATIVE_INCLUDE_PATHS false

proc sim_callback_procedure_vhdl { entity_name } {
   if {1} { 
      add_fileset_file mentor/altera_msi_to_gic_gen.sv SYSTEM_VERILOG_ENCRYPT PATH "mentor/altera_msi_to_gic_gen.sv" {MENTOR_SPECIFIC}
	  add_fileset_file mentor/altera_msi_to_gic_gen_fifo.v VERILOG_ENCRYPT PATH "mentor/altera_msi_to_gic_gen_fifo.v" {MENTOR_SPECIFIC}
   }

   add_fileset_file altera_msi_to_gic_gen.sv SYSTEM_VERILOG PATH "./altera_msi_to_gic_gen.sv" {{ALDEC_SPECIFIC} {CADENCE_SPECIFIC} {SYNOPSYS_SPECIFIC}}
   add_fileset_file altera_msi_to_gic_gen_fifo.v VERILOG PATH "./altera_msi_to_gic_gen_fifo.v" {{ALDEC_SPECIFIC} {CADENCE_SPECIFIC} {SYNOPSYS_SPECIFIC}}
}

# 
# parameters
# 

add_parameter           DEVICE_FAMILY		STRING          ""
set_parameter_property  DEVICE_FAMILY		SYSTEM_INFO     "DEVICE_FAMILY"
set_parameter_property  DEVICE_FAMILY		HDL_PARAMETER   true
set_parameter_property  DEVICE_FAMILY		VISIBLE	      	false

add_parameter 			MSG_DATA_WORD 		INTEGER 		32
set_parameter_property 	MSG_DATA_WORD 		ALLOWED_RANGES  1:32
set_parameter_property 	MSG_DATA_WORD 		DISPLAY_NAME	"No. of vector entries"
set_parameter_property 	MSG_DATA_WORD 		DISPLAY_HINT 	"Number of Avalon MM slave vector accepting message data value"
set_parameter_property 	MSG_DATA_WORD 		TYPE 			INTEGER
set_parameter_property 	MSG_DATA_WORD 		UNITS 			None
set_parameter_property 	MSG_DATA_WORD 		HDL_PARAMETER 	true
set_parameter_property 	MSG_DATA_WORD 		AFFECTS_GENERATION false

add_parameter 			ADDR_WIDTH 			INTEGER 		5
set_parameter_property 	ADDR_WIDTH 			TYPE 			INTEGER
set_parameter_property 	ADDR_WIDTH 			UNITS 			None
set_parameter_property	ADDR_WIDTH 			HDL_PARAMETER 	true
set_parameter_property 	ADDR_WIDTH	 		AFFECTS_GENERATION false
set_parameter_property 	ADDR_WIDTH	 		VISIBLE 		false
set_parameter_property  ADDR_WIDTH 			DERIVED 		TRUE

add_parameter 			DATA_ENTRY_DEPTH 	INTEGER 		1
set_parameter_property 	DATA_ENTRY_DEPTH 	ALLOWED_RANGES  1:32
set_parameter_property 	DATA_ENTRY_DEPTH 	DISPLAY_NAME 	"Vector depth"
set_parameter_property 	DATA_ENTRY_DEPTH 	DISPLAY_HINT 	"Depth of FIFO implemented at each data word address"
set_parameter_property 	DATA_ENTRY_DEPTH 	TYPE 			INTEGER
set_parameter_property 	DATA_ENTRY_DEPTH 	UNITS 			None
set_parameter_property 	DATA_ENTRY_DEPTH 	HDL_PARAMETER 	true
set_parameter_property 	DATA_ENTRY_DEPTH	AFFECTS_GENERATION false

add_parameter 			FIFO_DEPTH 			INTEGER 		4
set_parameter_property 	FIFO_DEPTH 			TYPE 			INTEGER
set_parameter_property 	FIFO_DEPTH 			UNITS 			None
set_parameter_property 	FIFO_DEPTH 			HDL_PARAMETER 	true
set_parameter_property 	FIFO_DEPTH			AFFECTS_GENERATION false
set_parameter_property  FIFO_DEPTH   		VISIBLE 		false
set_parameter_property  FIFO_DEPTH 			DERIVED 		TRUE

add_parameter 			MEMORY_TYPE 		STRING 		 	"None"
set_parameter_property 	MEMORY_TYPE		 	DISPLAY_NAME 	"Memory type"
set_parameter_property 	MEMORY_TYPE 		DISPLAY_HINT 	"Select the memory block type to be used in the FIFO"
set_parameter_property 	MEMORY_TYPE 		HDL_PARAMETER 	true
set_parameter_property 	MEMORY_TYPE 		AFFECTS_GENERATION false
set_parameter_property  MEMORY_TYPE 		ALLOWED_RANGES  {"None" "RAM_BLOCK_TYPE=MLAB: MLAB" "RAM_BLOCK_TYPE=M512: M512" "RAM_BLOCK_TYPE=M4K: M4K" "RAM_BLOCK_TYPE=MRam: MRam" "RAM_BLOCK_TYPE=M9K: M9K" "RAM_BLOCK_TYPE=M10K: M10K" "RAM_BLOCK_TYPE=M20K: M20K" "RAM_BLOCK_TYPE=M144K: M144K"}

#
# add system info parameter
add_parameter           deviceFeaturesSystemInfo   STRING 			"None"
set_parameter_property  deviceFeaturesSystemInfo   system_info		"DEVICE_FEATURES"
set_parameter_property  deviceFeaturesSystemInfo   VISIBLE false
# 
# display items
# 


# 
# connection point clock
# 
add_interface clock clock end
set_interface_property clock clockRate 0
set_interface_property clock ENABLED true
set_interface_property clock EXPORT_OF ""
set_interface_property clock PORT_NAME_MAP ""
set_interface_property clock SVD_ADDRESS_GROUP ""

add_interface_port clock clk clk Input 1


# 
# connection point reset
# 
add_interface reset reset end
set_interface_property reset associatedClock clock
set_interface_property reset synchronousEdges DEASSERT
set_interface_property reset ENABLED true
set_interface_property reset EXPORT_OF ""
set_interface_property reset PORT_NAME_MAP ""
set_interface_property reset SVD_ADDRESS_GROUP ""

add_interface_port reset reset_n reset_n Input 1


# 
# connection point csr
# 
add_interface csr avalon end
set_interface_property csr addressUnits WORDS
set_interface_property csr associatedClock clock
set_interface_property csr associatedReset reset
set_interface_property csr bitsPerSymbol 8
set_interface_property csr burstOnBurstBoundariesOnly false
set_interface_property csr burstcountUnits WORDS
set_interface_property csr explicitAddressSpan 0
set_interface_property csr holdTime 0
set_interface_property csr linewrapBursts false
set_interface_property csr maximumPendingReadTransactions 0
set_interface_property csr readLatency 1
set_interface_property csr readWaitTime 0
set_interface_property csr setupTime 0
set_interface_property csr timingUnits Cycles
set_interface_property csr writeWaitTime 0
set_interface_property csr ENABLED true
set_interface_property csr EXPORT_OF ""
set_interface_property csr PORT_NAME_MAP ""
set_interface_property csr SVD_ADDRESS_GROUP ""

add_interface_port csr csr_write write Input 1
add_interface_port csr csr_read read Input 1
add_interface_port csr csr_addr address Input 2
add_interface_port csr csr_wrdata writedata Input 32
add_interface_port csr csr_rddata readdata Output 32
set_interface_assignment csr embeddedsw.configuration.isFlash 0
set_interface_assignment csr embeddedsw.configuration.isMemoryDevice 0
set_interface_assignment csr embeddedsw.configuration.isNonVolatileStorage 0
set_interface_assignment csr embeddedsw.configuration.isPrintableDevice 0
                                                                      

# 
# connection point vector_slave
# 
add_interface vector_slave avalon end
set_interface_property vector_slave addressUnits WORDS
set_interface_property vector_slave associatedClock clock
set_interface_property vector_slave associatedReset reset
set_interface_property vector_slave bitsPerSymbol 8
set_interface_property vector_slave burstOnBurstBoundariesOnly false
set_interface_property vector_slave burstcountUnits WORDS
set_interface_property vector_slave explicitAddressSpan 0
set_interface_property vector_slave holdTime 0
set_interface_property vector_slave linewrapBursts false
set_interface_property vector_slave maximumPendingReadTransactions 0
set_interface_property vector_slave readLatency 1
set_interface_property vector_slave readWaitTime 0
set_interface_property vector_slave setupTime 0
set_interface_property vector_slave timingUnits Cycles
set_interface_property vector_slave writeWaitTime 0
set_interface_property vector_slave ENABLED true
set_interface_property vector_slave EXPORT_OF ""
set_interface_property vector_slave PORT_NAME_MAP ""
set_interface_property vector_slave SVD_ADDRESS_GROUP ""

add_interface_port vector_slave avmm_addr address Input ADDR_WIDTH
add_interface_port vector_slave avmm_wrdata writedata Input 32
add_interface_port vector_slave avmm_rddata readdata Output 32
add_interface_port vector_slave avmm_write write Input 1
add_interface_port vector_slave avmm_read read Input 1
set_interface_assignment vector_slave embeddedsw.configuration.isFlash 0
set_interface_assignment vector_slave embeddedsw.configuration.isMemoryDevice 0
set_interface_assignment vector_slave embeddedsw.configuration.isNonVolatileStorage 0
set_interface_assignment vector_slave embeddedsw.configuration.isPrintableDevice 0


# 
# connection point interrupt_sender
# 
add_interface interrupt_sender interrupt end
set_interface_property interrupt_sender associatedAddressablePoint ""
set_interface_property interrupt_sender associatedClock clock
set_interface_property interrupt_sender associatedReset reset
set_interface_property interrupt_sender ENABLED true
set_interface_property interrupt_sender EXPORT_OF ""
set_interface_property interrupt_sender PORT_NAME_MAP ""
set_interface_property interrupt_sender SVD_ADDRESS_GROUP ""

add_interface_port interrupt_sender irq irq Output 1

proc elaborate {} {
  
  set msg_data_word_param    [ get_parameter_value MSG_DATA_WORD ]
  set data_entry_depth_param [ get_parameter_value DATA_ENTRY_DEPTH ]
  set memory_type_param 	 [ get_parameter_value MEMORY_TYPE ]
  set device_family_param 	 [ get_parameter_value DEVICE_FAMILY ]
  
  if {$data_entry_depth_param != 1 && $data_entry_depth_param != 4 && $data_entry_depth_param != 8 && $data_entry_depth_param != 16 && $data_entry_depth_param != 32} {
	  send_message Info "For better resource utilization, select Vector depth which is greater than 3 and equals to power of 2."
  }

  if {$msg_data_word_param < 1 || $msg_data_word_param > 32 } {
    send_message Error "No. of vector entries must be in within 1 to 32"
  }
  
  if {$data_entry_depth_param < 1 || $data_entry_depth_param > 32 } {
    send_message Error "Vector depth must be in within 1 to 32"
  }
  
  if {$data_entry_depth_param > 1} {
	  set_parameter_property MEMORY_TYPE ENABLED true
	  if {$memory_type_param == "None"} {
		  send_message Error "When vector depth > 1, memory block will be used. Please select a memory block type"
	  }
  } else {
	  set_parameter_property MEMORY_TYPE ENABLED false
	  send_message Info "When vector depth is 1, registers are used to store the data instead of memory block"
  }

}

proc validate {} {
	set supported_ram_type  [ proc_get_supported_ram_type ]
	set_parameter_property  MEMORY_TYPE         "ALLOWED_RANGES"  $supported_ram_type
	set_parameter_value 	ADDR_WIDTH 			[ proc_get_derive_addr_width  [ get_parameter_value MSG_DATA_WORD ] ]
	set_parameter_value		FIFO_DEPTH			[ proc_get_derive_fifo_depth  [ get_parameter_value DATA_ENTRY_DEPTH ] ]

	# Add DTS paramters
	set_module_assignment embeddedsw.dts.vendor "ALTR"
	set_module_assignment embeddedsw.dts.group "msi"
	set_module_assignment embeddedsw.dts.name "msi"
	set_module_assignment embeddedsw.dts.compatible "altr,msi-1.0" 
	set_module_assignment embeddedsw.dts.params.num-vectors [ get_parameter_value MSG_DATA_WORD ]
	set_module_assignment embeddedsw.dts.params.msi-controller 1
}

proc proc_get_derive_addr_width {parameter} {
	set i 1
	set addr_width_value 0

    while {$i < $parameter} {
	  set addr_width_value [expr {$addr_width_value + 1}];
	  set i [expr {$i << 1}];
    }
	
	if {$parameter == 1} {
		return 1
	} else {
		return "$addr_width_value"
	}
	
}

proc proc_get_derive_fifo_depth {parameter} {
	if {$parameter <= 4} {
		return 4
	} elseif {$parameter > 4 && $parameter <= 8} {
		return 8
	} elseif {$parameter > 8 && $parameter <= 16} {
		return 16
	} elseif {$parameter > 16 && $parameter <= 32} {
		return 32
	} else {
		return 32
	}
}

proc proc_get_supported_ram_type {} {
    set supported_ram_type_system_info [list]
    array set feature_array  [get_parameter_value deviceFeaturesSystemInfo]
    foreach one_feature [array names feature_array] {
        if { [ string match "*_MEMORY*" "$one_feature" ] } {
            if { $feature_array($one_feature) } {
                lappend supported_ram_type_system_info "$one_feature"
            }
        }
    }
    set supported_ram_type [list]
    foreach ram_type $supported_ram_type_system_info {
        switch $ram_type {
            "M4K_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=M4K: M4K"
            }
            "M9K_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=M9K: M9K"
            }
            "M10K_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=M10K: M10K"
            }
            "M20K_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=M20K: M20K"
            }
            "M144K_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=M144K: M144K"
            }
            "MRAM_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=MRam: MRam"
            }
            "MLAB_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=MLAB: MLAB"
            }
            "M512_MEMORY" {
                lappend supported_ram_type "RAM_BLOCK_TYPE=M512: M512"
            }
            default {
                # Should never enter this function
                send_message error "$ram_type is not a valid ram type"
            }

        }
    }
	lappend supported_ram_type "None"	
    return "$supported_ram_type"
}

