/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedInteger.h"

#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedInteger);

/* Hash table */

static const HashTableValue JSSVGAnimatedIntegerTableValues[4] =
{
    { "baseVal", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedIntegerBaseVal), (intptr_t)setJSSVGAnimatedIntegerBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedIntegerAnimVal), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedIntegerConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedIntegerTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGAnimatedIntegerTableValues, 0 };
#else
    { 8, 7, JSSVGAnimatedIntegerTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedIntegerConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedIntegerConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedIntegerConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedIntegerConstructorTableValues, 0 };
#endif

class JSSVGAnimatedIntegerConstructor : public DOMConstructorObject {
public:
    JSSVGAnimatedIntegerConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGAnimatedIntegerConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGAnimatedIntegerPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGAnimatedIntegerConstructor::s_info = { "SVGAnimatedIntegerConstructor", 0, &JSSVGAnimatedIntegerConstructorTable, 0 };

bool JSSVGAnimatedIntegerConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedIntegerConstructor, DOMObject>(exec, &JSSVGAnimatedIntegerConstructorTable, this, propertyName, slot);
}

bool JSSVGAnimatedIntegerConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedIntegerConstructor, DOMObject>(exec, &JSSVGAnimatedIntegerConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedIntegerPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedIntegerPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedIntegerPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedIntegerPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedIntegerPrototype::s_info = { "SVGAnimatedIntegerPrototype", 0, &JSSVGAnimatedIntegerPrototypeTable, 0 };

JSObject* JSSVGAnimatedIntegerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedInteger>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedInteger::s_info = { "SVGAnimatedInteger", 0, &JSSVGAnimatedIntegerTable, 0 };

JSSVGAnimatedInteger::JSSVGAnimatedInteger(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedInteger> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGAnimatedInteger::~JSSVGAnimatedInteger()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGAnimatedInteger::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedIntegerPrototype(JSSVGAnimatedIntegerPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedInteger::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedInteger, Base>(exec, &JSSVGAnimatedIntegerTable, this, propertyName, slot);
}

bool JSSVGAnimatedInteger::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedInteger, Base>(exec, &JSSVGAnimatedIntegerTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedIntegerBaseVal(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAnimatedInteger* castedThis = static_cast<JSSVGAnimatedInteger*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedInteger* imp = static_cast<SVGAnimatedInteger*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->baseVal());
    return result;
}

JSValue jsSVGAnimatedIntegerAnimVal(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAnimatedInteger* castedThis = static_cast<JSSVGAnimatedInteger*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedInteger* imp = static_cast<SVGAnimatedInteger*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->animVal());
    return result;
}

JSValue jsSVGAnimatedIntegerConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGAnimatedInteger* domObject = static_cast<JSSVGAnimatedInteger*>(asObject(slotBase));
    return JSSVGAnimatedInteger::getConstructor(exec, domObject->globalObject());
}
void JSSVGAnimatedInteger::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedInteger, Base>(exec, propertyName, value, &JSSVGAnimatedIntegerTable, this, slot);
}

void setJSSVGAnimatedIntegerBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGAnimatedInteger* castedThisObj = static_cast<JSSVGAnimatedInteger*>(thisObject);
    SVGAnimatedInteger* imp = static_cast<SVGAnimatedInteger*>(castedThisObj->impl());
    imp->setBaseVal(value.toInt32(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

JSValue JSSVGAnimatedInteger::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedIntegerConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedInteger* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedInteger>(exec, globalObject, object, context);
}
SVGAnimatedInteger* toSVGAnimatedInteger(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedInteger::s_info) ? static_cast<JSSVGAnimatedInteger*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
