# Qt core io module

HEADERS +=  \
        io/qabstractfileengine.h \
        io/qabstractfileengine_p.h \
        io/qbuffer.h \
        io/qdatastream.h \
        io/qdatastream_p.h \
        io/qdataurl_p.h \
        io/qdebug.h \
        io/qdir.h \
        io/qdiriterator.h \
        io/qfile.h \
        io/qfileinfo.h \
        io/qfileinfo_p.h \
        io/qiodevice.h \
        io/qiodevice_p.h \
        io/qnoncontiguousbytedevice_p.h \
        io/qprocess.h \
        io/qprocess_p.h \
        io/qtextstream.h \
        io/qtemporaryfile.h \
        io/qresource_p.h \
        io/qresource_iterator_p.h \
        io/qurl.h \
        io/qsettings.h \
        io/qsettings_p.h \
        io/qfsfileengine.h \
        io/qfsfileengine_p.h \
        io/qfsfileengine_iterator_p.h \
        io/qfilesystemwatcher.h \
        io/qfilesystemwatcher_p.h

SOURCES += \
        io/qabstractfileengine.cpp \
        io/qbuffer.cpp \
        io/qdatastream.cpp \
        io/qdataurl.cpp \
        io/qdebug.cpp \
        io/qdir.cpp \
        io/qdiriterator.cpp \
        io/qfile.cpp \
        io/qfileinfo.cpp \
        io/qiodevice.cpp \
        io/qnoncontiguousbytedevice.cpp \
        io/qprocess.cpp \
        io/qtextstream.cpp \
        io/qtemporaryfile.cpp \
        io/qresource.cpp \
        io/qresource_iterator.cpp \
        io/qurl.cpp \
        io/qsettings.cpp \
        io/qfsfileengine.cpp \
        io/qfsfileengine_iterator.cpp \
        io/qfilesystemwatcher.cpp

win32 {
        SOURCES += io/qsettings_win.cpp
        SOURCES += io/qprocess_win.cpp
        SOURCES += io/qfsfileengine_win.cpp

        SOURCES += io/qfsfileengine_iterator_win.cpp
        SOURCES += io/qfilesystemwatcher_win.cpp
        HEADERS += io/qfilesystemwatcher_win_p.h
        HEADERS += io/qwindowspipewriter_p.h
        SOURCES += io/qwindowspipewriter.cpp
} else:unix {
        SOURCES += io/qfsfileengine_unix.cpp
        SOURCES += io/qfsfileengine_iterator_unix.cpp
        symbian:SOURCES += io/qprocess_symbian.cpp
        else:SOURCES += io/qprocess_unix.cpp
        macx-*: {
            HEADERS += io/qfilesystemwatcher_fsevents_p.h
            SOURCES += io/qsettings_mac.cpp io/qfilesystemwatcher_fsevents.cpp
        }

        linux-*:!symbian {
            SOURCES += \
                    io/qfilesystemwatcher_inotify.cpp \
                    io/qfilesystemwatcher_dnotify.cpp

            HEADERS += \
                    io/qfilesystemwatcher_inotify_p.h \
                    io/qfilesystemwatcher_dnotify_p.h
        }

        freebsd-*|macx-*|darwin-*|openbsd-*:{
            SOURCES += io/qfilesystemwatcher_kqueue.cpp
            HEADERS += io/qfilesystemwatcher_kqueue_p.h
        }

        symbian {
            SOURCES += io/qfilesystemwatcher_symbian.cpp
            HEADERS += io/qfilesystemwatcher_symbian_p.h
            INCLUDEPATH += $$MW_LAYER_SYSTEMINCLUDE
            LIBS += -lplatformenv
        }
}
