#!/bin/sh

# Remove mass storage module and mount loopback file.  

FILE=/dev/shm/20M

rmmod g_mass_storage

# Attach loopback file to /dev/loop0
[ ! -e /dev/loop0 ] && mknod /dev/loop0 b 7 0
losetup -o 4096 /dev/loop0 $FILE || die

# Mount fat32 partition
mkdir -p /mnt/loop
mount -t vfat /dev/loop0 /mnt/loop || die

# Copy files from loopback file
touch /mnt/loop/testfile || die

# Unmount and unAttach
umount /mnt/loop || die
losetup -d /dev/loop0 || die

# Delete file to free up memory
rm -f $FILE
