#!/bin/sh

for iface in usb0 eth0
do
	HWADDR=`/sbin/ifconfig $iface | awk -e '/HWaddr/{print $5}'`
	IPADDR=`/sbin/ifconfig $iface | awk -e '/Bcast/{print $2}' | sed -e 's/.*://'`
	BCAST=`/sbin/ifconfig $iface | awk -e '/Bcast/{print $3}' | sed -e 's/.*://'`
	NETMASK=`/sbin/ifconfig $iface | awk -e '/Bcast/{print $4}' | sed -e 's/.*://'`
	MODE=`grep $iface /etc/network/interfaces | grep iface | awk -e '{print $4}'`
	if [ x$IPADDR == "x" ]
	then
		IPADDR=10.0.45.14
	fi 
	if [ x$NETMASK == "x" ]
	then
		NETMASK=255.255.0.0
	fi 
	if [ x$BCAST == "x" ]
	then
		BCAST=10.0.255.255
	fi
	echo "$iface $HWADDR $MODE $IPADDR $BCAST $NETMASK"
done

