#!/usr/bin/env python

import cgi, os, subprocess
from struct import *
from collections import namedtuple

form = cgi.FieldStorage()

fmt =  '<16sH24sHHHHHHHHHHHiii6i';
ViewerConfig = namedtuple('ViewerConfig', """
 modelnum
 serialnum
 manufacturer
 rows
 reserved 
 columns
 fpgarev
 dsprev
 unused
 thermbeta
 maxcurrent
 reserved1
 bottommaskedrows
 topmaskedrows
 pixelwidth
 pixelheight
 sensorserialnum
 reserved2_1
 reserved2_2
 reserved2_3
 reserved2_4
 reserved2_5
 reserved2_6
""");

print "Content-type: text/html"
print
print """
<html>
<head><title>MityCAM Serial Number Config Page</title></head>
<body>
"""

if form.getvalue('serialno'):
	print """
	<h1> Updating...</h1>
"""
	tmp = open('/home/root/application/version/cam_part.txt','w')
	tmp.write(form.getvalue('campartno'))
	tmp.close()

	tmp = open('/home/root/application/version/io_board_rev.txt','w')
	tmp.write(form.getvalue('ioboardrev'))
	tmp.close()

	tmp = open('/home/root/application/version/sensor_board_rev.txt','w')
	tmp.write(form.getvalue('sensorboardrev'))
	tmp.close()

	tmp = open('/home/root/application/version/sensor_part.txt','w')
	tmp.write(form.getvalue('sensorpart'))
	tmp.close()

	tmp = open('/home/root/application/version/soc_io_board_rev.txt','w')
	tmp.write(form.getvalue('socioboardrev'))
	tmp.close()

	tmp = open('/home/root/application/version/serial.txt','w')
	tmp.write(form.getvalue('serialno'))
	tmp.close()

	tmp = open('/etc/uBootStatic.env','w')
	tmp.write('ethaddr=%s\n' % (form.getvalue('macaddr')))
	tmp.close()

	tmp = open('/home/root/application/version/mityviewer_config.bin','rb')
	mityviewer_cs = tmp.read();
	tmp.close()
	mv_config = ViewerConfig._make(unpack(fmt, mityviewer_cs))
	mv_config = mv_config._replace(serialnum=int(form.getvalue('serialno')))
	mityviewer_cs = pack(fmt, *mv_config)

	tmp = open('/home/root/application/version/mityviewer_config.bin','w')
	tmp.write(mityviewer_cs)
	tmp.close()

	result = subprocess.check_output(['/bin/sync'], stderr=subprocess.STDOUT, shell=True)
	result = subprocess.check_output(['/sbin/reboot'], stderr=subprocess.STDOUT, shell=True)

serialno = open("/home/root/application/version/serial.txt", "rb").read();
campartno = open("/home/root/application/version/cam_part.txt", "rb").read();
ioboardrev = open("/home/root/application/version/io_board_rev.txt", "rb").read();
sensorboardrev = open("/home/root/application/version/sensor_board_rev.txt", "rb").read();
sensorpart = open("/home/root/application/version/sensor_part.txt", "rb").read();
socioboardrev = open("/home/root/application/version/soc_io_board_rev.txt", "rb").read();
macaddr = open("/etc/uBootStatic.env", "rb").read();
macaddr = macaddr.replace('ethaddr=', '');

print """

  <h1> MityCAM Serial Number Config Page</h1>

"""

print """

   <h2> Serial Configuration Update </h2>

   <form enctype="multipart/form-data" 
                     action="serialconfig.py" method="post">
   <table border=1>
   <tr><th>Parameter</th><th>Value</th></tr>
   <tr><td>Camera Serial Number</td><td><input type="text" name="serialno" value="%s"></td></tr>
   <tr><td>Camera Part Number</td><td><input type="text" name="campartno" value="%s"></td></tr>
   <tr><td>IO Board</td><td><input type="text" name="ioboardrev" value="%s"></td></tr>
   <tr><td>Sensor Board</td><td><input type="text" name="sensorboardrev" value="%s"></td></tr>
   <tr><td>Sensor</td><td><input type="text" name="sensorpart" value="%s"></td></tr>
   <tr><td>Processor Board</td><td><input type="text" name="socioboardrev" value="%s"></td></tr>
   <tr><td>Ethernet MAC Address</td><td><input type="text" name="macaddr" value="%s"></td></tr>
   </tr>
""" % (serialno, campartno, ioboardrev, sensorboardrev, sensorpart, socioboardrev, macaddr)

print """
   </table>
   <br>
   <input type="submit" value="Update" /></p>
   </form>

   <br>
   <A href='/index.py'>Main Page</a>

</body>
</html>
"""


